/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.BaseReferenceRequestBuilder;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.http.BaseWithReferenceRequest;
import com.microsoft.graph.options.Option;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BaseWithReferenceRequestBuilder<T, T2 extends BaseWithReferenceRequest<T>, T3 extends BaseReferenceRequestBuilder<T, ? extends BaseReferenceRequest<T>>>
extends BaseRequestBuilder<T> {
    private Class<T2> wReferenceRequestClass;
    private Class<T3> refRequestBuilderClass;

    public BaseWithReferenceRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions, @Nonnull Class<T2> withReferenceRequestClass, @Nonnull Class<T3> referenceRequestBuilderClass) {
        super(requestUrl, client, requestOptions);
        this.wReferenceRequestClass = Objects.requireNonNull(withReferenceRequestClass, "parameter withReferenceRequestClass cannot be null");
        this.refRequestBuilderClass = Objects.requireNonNull(referenceRequestBuilderClass, "parameter referenceRequestBuilderClass cannot be null");
    }

    @Nonnull
    public T2 buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public T2 buildRequest(@Nullable List<? extends Option> requestOptions) {
        try {
            return (T2)((BaseWithReferenceRequest)this.wReferenceRequestClass.getConstructor(String.class, IBaseClient.class, List.class).newInstance(this.getRequestUrl(), this.getClient(), requestOptions));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new ClientException("Could not find the required class", ex);
        }
    }

    @Nullable
    public T3 reference() {
        try {
            return (T3)((BaseReferenceRequestBuilder)this.refRequestBuilderClass.getConstructor(String.class, IBaseClient.class, List.class).newInstance(this.getRequestUrl() + "/$ref", this.getClient(), this.getOptions(new Option[0])));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new ClientException("Could not find the required class", ex);
        }
    }
}

