/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.LinkedResource;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.LinkedResourceCollectionPage;
import com.microsoft.graph.requests.LinkedResourceCollectionRequestBuilder;
import com.microsoft.graph.requests.LinkedResourceCollectionResponse;
import com.microsoft.graph.requests.LinkedResourceRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LinkedResourceCollectionRequest
extends BaseEntityCollectionRequest<LinkedResource, LinkedResourceCollectionResponse, LinkedResourceCollectionPage> {
    public LinkedResourceCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, LinkedResourceCollectionResponse.class, LinkedResourceCollectionPage.class, LinkedResourceCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<LinkedResource> postAsync(@Nonnull LinkedResource newLinkedResource) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new LinkedResourceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newLinkedResource);
    }

    @Nonnull
    public LinkedResource post(@Nonnull LinkedResource newLinkedResource) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new LinkedResourceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newLinkedResource);
    }

    @Nonnull
    public LinkedResourceCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public LinkedResourceCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public LinkedResourceCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public LinkedResourceCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public LinkedResourceCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public LinkedResourceCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public LinkedResourceCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public LinkedResourceCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public LinkedResourceCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

