/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.ChatMessage;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ChatMessageCollectionRequestBuilder;
import com.microsoft.graph.requests.ChatMessageHostedContentCollectionRequestBuilder;
import com.microsoft.graph.requests.ChatMessageHostedContentRequestBuilder;
import com.microsoft.graph.requests.ChatMessageRequest;
import com.microsoft.graph.requests.ChatMessageSoftDeleteRequestBuilder;
import com.microsoft.graph.requests.ChatMessageUndoSoftDeleteRequestBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChatMessageRequestBuilder
extends BaseRequestBuilder<ChatMessage> {
    public ChatMessageRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    @Nonnull
    public ChatMessageRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public ChatMessageRequest buildRequest(@Nonnull List<? extends Option> requestOptions) {
        return new ChatMessageRequest(this.getRequestUrl(), this.getClient(), requestOptions);
    }

    @Nonnull
    public ChatMessageHostedContentCollectionRequestBuilder hostedContents() {
        return new ChatMessageHostedContentCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("hostedContents"), this.getClient(), null);
    }

    @Nonnull
    public ChatMessageHostedContentRequestBuilder hostedContents(@Nonnull String id) {
        return new ChatMessageHostedContentRequestBuilder(this.getRequestUrlWithAdditionalSegment("hostedContents") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public ChatMessageCollectionRequestBuilder replies() {
        return new ChatMessageCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("replies"), this.getClient(), null);
    }

    @Nonnull
    public ChatMessageRequestBuilder replies(@Nonnull String id) {
        return new ChatMessageRequestBuilder(this.getRequestUrlWithAdditionalSegment("replies") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public ChatMessageSoftDeleteRequestBuilder softDelete() {
        return new ChatMessageSoftDeleteRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.softDelete"), this.getClient(), null);
    }

    @Nonnull
    public ChatMessageUndoSoftDeleteRequestBuilder undoSoftDelete() {
        return new ChatMessageUndoSoftDeleteRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.undoSoftDelete"), this.getClient(), null);
    }
}

