// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.SubjectSet;
import com.microsoft.graph.identitygovernance.models.WorkflowExecutionTrigger;
import com.microsoft.graph.identitygovernance.models.WorkflowExecutionConditions;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Trigger And Scope Based Conditions.
 */
public class TriggerAndScopeBasedConditions extends WorkflowExecutionConditions implements IJsonBackedObject {


    /**
     * The Scope.
     * Defines who the workflow runs for.
     */
    @SerializedName(value = "scope", alternate = {"Scope"})
    @Expose
	@Nullable
    public SubjectSet scope;

    /**
     * The Trigger.
     * What triggers a workflow to run.
     */
    @SerializedName(value = "trigger", alternate = {"Trigger"})
    @Expose
	@Nullable
    public WorkflowExecutionTrigger trigger;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
