// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.AccessReviewHistoryStatus;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Review History Instance.
 */
public class AccessReviewHistoryInstance extends Entity implements IJsonBackedObject {


    /**
     * The Download Uri.
     * Uri that can be used to retrieve review history data. This URI will be active for 24 hours after being generated. Required.
     */
    @SerializedName(value = "downloadUri", alternate = {"DownloadUri"})
    @Expose
	@Nullable
    public String downloadUri;

    /**
     * The Expiration Date Time.
     * Timestamp when this instance and associated data expires and the history is deleted. Required.
     */
    @SerializedName(value = "expirationDateTime", alternate = {"ExpirationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime expirationDateTime;

    /**
     * The Fulfilled Date Time.
     * Timestamp when all of the available data for this instance was collected and is set after this instance's status is set to done. Required.
     */
    @SerializedName(value = "fulfilledDateTime", alternate = {"FulfilledDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime fulfilledDateTime;

    /**
     * The Review History Period End Date Time.
     * Timestamp reviews ending on or before this date will be included in the fetched history data.
     */
    @SerializedName(value = "reviewHistoryPeriodEndDateTime", alternate = {"ReviewHistoryPeriodEndDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime reviewHistoryPeriodEndDateTime;

    /**
     * The Review History Period Start Date Time.
     * Timestamp reviews starting on or after this date will be included in the fetched history data.
     */
    @SerializedName(value = "reviewHistoryPeriodStartDateTime", alternate = {"ReviewHistoryPeriodStartDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime reviewHistoryPeriodStartDateTime;

    /**
     * The Run Date Time.
     * Timestamp when the instance's history data is scheduled to be generated.
     */
    @SerializedName(value = "runDateTime", alternate = {"RunDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime runDateTime;

    /**
     * The Status.
     * Represents the status of the review history data collection. The possible values are: done, inProgress, error, requested, unknownFutureValue. Once the status has been marked as done, a link can be generated to retrieve the instance's data by calling generateDownloadUri method.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public AccessReviewHistoryStatus status;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
