// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AttendanceInterval;
import com.microsoft.graph.models.Identity;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Attendance Record.
 */
public class AttendanceRecord extends Entity implements IJsonBackedObject {


    /**
     * The Attendance Intervals.
     * List of time periods between joining and leaving a meeting.
     */
    @SerializedName(value = "attendanceIntervals", alternate = {"AttendanceIntervals"})
    @Expose
	@Nullable
    public java.util.List<AttendanceInterval> attendanceIntervals;

    /**
     * The Email Address.
     * Email address of the user associated with this attendance record.
     */
    @SerializedName(value = "emailAddress", alternate = {"EmailAddress"})
    @Expose
	@Nullable
    public String emailAddress;

    /**
     * The Identity.
     * Identity of the user associated with this attendance record.
     */
    @SerializedName(value = "identity", alternate = {"Identity"})
    @Expose
	@Nullable
    public Identity identity;

    /**
     * The Role.
     * Role of the attendee. Possible values are: None, Attendee, Presenter, and Organizer.
     */
    @SerializedName(value = "role", alternate = {"Role"})
    @Expose
	@Nullable
    public String role;

    /**
     * The Total Attendance In Seconds.
     * Total duration of the attendances in seconds.
     */
    @SerializedName(value = "totalAttendanceInSeconds", alternate = {"TotalAttendanceInSeconds"})
    @Expose
	@Nullable
    public Integer totalAttendanceInSeconds;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
