// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.ExcludeTarget;
import com.microsoft.graph.models.AuthenticationMethodsRegistrationCampaignIncludeTarget;
import com.microsoft.graph.models.AdvancedConfigState;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Methods Registration Campaign.
 */
public class AuthenticationMethodsRegistrationCampaign implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Exclude Targets.
     * Users and groups of users that are excluded from being prompted to set up the authentication method.
     */
    @SerializedName(value = "excludeTargets", alternate = {"ExcludeTargets"})
    @Expose
	@Nullable
    public java.util.List<ExcludeTarget> excludeTargets;

    /**
     * The Include Targets.
     * Users and groups of users that are prompted to set up the authentication method.
     */
    @SerializedName(value = "includeTargets", alternate = {"IncludeTargets"})
    @Expose
	@Nullable
    public java.util.List<AuthenticationMethodsRegistrationCampaignIncludeTarget> includeTargets;

    /**
     * The Snooze Duration In Days.
     * Specifies the number of days that the user sees a prompt again if they select 'Not now' and snoozes the prompt. Minimum: 0 days. Maximum: 14 days. If the value is '0', the user is prompted during every MFA attempt.
     */
    @SerializedName(value = "snoozeDurationInDays", alternate = {"SnoozeDurationInDays"})
    @Expose
	@Nullable
    public Integer snoozeDurationInDays;

    /**
     * The State.
     * Enable or disable the feature. Possible values are: default, enabled, disabled, unknownFutureValue. The default value is used when the configuration hasn't been explicitly set and uses the default behavior of Microsoft Entra ID for the setting. The default value is disabled.
     */
    @SerializedName(value = "state", alternate = {"State"})
    @Expose
	@Nullable
    public AdvancedConfigState state;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
