// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.Prompt;
import com.microsoft.graph.models.RecordOperation;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Call Record Response Parameter Set.
 */
public class CallRecordResponseParameterSet {
    /**
     * The prompts.
     * 
     */
    @SerializedName(value = "prompts", alternate = {"Prompts"})
    @Expose
	@Nullable
    public java.util.List<Prompt> prompts;

    /**
     * The barge In Allowed.
     * 
     */
    @SerializedName(value = "bargeInAllowed", alternate = {"BargeInAllowed"})
    @Expose
	@Nullable
    public Boolean bargeInAllowed;

    /**
     * The initial Silence Timeout In Seconds.
     * 
     */
    @SerializedName(value = "initialSilenceTimeoutInSeconds", alternate = {"InitialSilenceTimeoutInSeconds"})
    @Expose
	@Nullable
    public Integer initialSilenceTimeoutInSeconds;

    /**
     * The max Silence Timeout In Seconds.
     * 
     */
    @SerializedName(value = "maxSilenceTimeoutInSeconds", alternate = {"MaxSilenceTimeoutInSeconds"})
    @Expose
	@Nullable
    public Integer maxSilenceTimeoutInSeconds;

    /**
     * The max Record Duration In Seconds.
     * 
     */
    @SerializedName(value = "maxRecordDurationInSeconds", alternate = {"MaxRecordDurationInSeconds"})
    @Expose
	@Nullable
    public Integer maxRecordDurationInSeconds;

    /**
     * The play Beep.
     * 
     */
    @SerializedName(value = "playBeep", alternate = {"PlayBeep"})
    @Expose
	@Nullable
    public Boolean playBeep;

    /**
     * The stop Tones.
     * 
     */
    @SerializedName(value = "stopTones", alternate = {"StopTones"})
    @Expose
	@Nullable
    public java.util.List<String> stopTones;

    /**
     * The client Context.
     * 
     */
    @SerializedName(value = "clientContext", alternate = {"ClientContext"})
    @Expose
	@Nullable
    public String clientContext;


    /**
     * Instiaciates a new CallRecordResponseParameterSet
     */
    public CallRecordResponseParameterSet() {}
    /**
     * Instiaciates a new CallRecordResponseParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected CallRecordResponseParameterSet(@Nonnull final CallRecordResponseParameterSetBuilder builder) {
        this.prompts = builder.prompts;
        this.bargeInAllowed = builder.bargeInAllowed;
        this.initialSilenceTimeoutInSeconds = builder.initialSilenceTimeoutInSeconds;
        this.maxSilenceTimeoutInSeconds = builder.maxSilenceTimeoutInSeconds;
        this.maxRecordDurationInSeconds = builder.maxRecordDurationInSeconds;
        this.playBeep = builder.playBeep;
        this.stopTones = builder.stopTones;
        this.clientContext = builder.clientContext;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static CallRecordResponseParameterSetBuilder newBuilder() {
        return new CallRecordResponseParameterSetBuilder();
    }
    /**
     * Fluent builder for the CallRecordResponseParameterSet
     */
    public static final class CallRecordResponseParameterSetBuilder {
        /**
         * The prompts parameter value
         */
        @Nullable
        protected java.util.List<Prompt> prompts;
        /**
         * Sets the Prompts
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public CallRecordResponseParameterSetBuilder withPrompts(@Nullable final java.util.List<Prompt> val) {
            this.prompts = val;
            return this;
        }
        /**
         * The bargeInAllowed parameter value
         */
        @Nullable
        protected Boolean bargeInAllowed;
        /**
         * Sets the BargeInAllowed
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public CallRecordResponseParameterSetBuilder withBargeInAllowed(@Nullable final Boolean val) {
            this.bargeInAllowed = val;
            return this;
        }
        /**
         * The initialSilenceTimeoutInSeconds parameter value
         */
        @Nullable
        protected Integer initialSilenceTimeoutInSeconds;
        /**
         * Sets the InitialSilenceTimeoutInSeconds
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public CallRecordResponseParameterSetBuilder withInitialSilenceTimeoutInSeconds(@Nullable final Integer val) {
            this.initialSilenceTimeoutInSeconds = val;
            return this;
        }
        /**
         * The maxSilenceTimeoutInSeconds parameter value
         */
        @Nullable
        protected Integer maxSilenceTimeoutInSeconds;
        /**
         * Sets the MaxSilenceTimeoutInSeconds
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public CallRecordResponseParameterSetBuilder withMaxSilenceTimeoutInSeconds(@Nullable final Integer val) {
            this.maxSilenceTimeoutInSeconds = val;
            return this;
        }
        /**
         * The maxRecordDurationInSeconds parameter value
         */
        @Nullable
        protected Integer maxRecordDurationInSeconds;
        /**
         * Sets the MaxRecordDurationInSeconds
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public CallRecordResponseParameterSetBuilder withMaxRecordDurationInSeconds(@Nullable final Integer val) {
            this.maxRecordDurationInSeconds = val;
            return this;
        }
        /**
         * The playBeep parameter value
         */
        @Nullable
        protected Boolean playBeep;
        /**
         * Sets the PlayBeep
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public CallRecordResponseParameterSetBuilder withPlayBeep(@Nullable final Boolean val) {
            this.playBeep = val;
            return this;
        }
        /**
         * The stopTones parameter value
         */
        @Nullable
        protected java.util.List<String> stopTones;
        /**
         * Sets the StopTones
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public CallRecordResponseParameterSetBuilder withStopTones(@Nullable final java.util.List<String> val) {
            this.stopTones = val;
            return this;
        }
        /**
         * The clientContext parameter value
         */
        @Nullable
        protected String clientContext;
        /**
         * Sets the ClientContext
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public CallRecordResponseParameterSetBuilder withClientContext(@Nullable final String val) {
            this.clientContext = val;
            return this;
        }
        /**
         * Instanciates a new CallRecordResponseParameterSetBuilder
         */
        @Nullable
        protected CallRecordResponseParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public CallRecordResponseParameterSet build() {
            return new CallRecordResponseParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.prompts != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("prompts", prompts));
        }
        if(this.bargeInAllowed != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("bargeInAllowed", bargeInAllowed));
        }
        if(this.initialSilenceTimeoutInSeconds != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("initialSilenceTimeoutInSeconds", initialSilenceTimeoutInSeconds));
        }
        if(this.maxSilenceTimeoutInSeconds != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("maxSilenceTimeoutInSeconds", maxSilenceTimeoutInSeconds));
        }
        if(this.maxRecordDurationInSeconds != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("maxRecordDurationInSeconds", maxRecordDurationInSeconds));
        }
        if(this.playBeep != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("playBeep", playBeep));
        }
        if(this.stopTones != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("stopTones", stopTones));
        }
        if(this.clientContext != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("clientContext", clientContext));
        }
        return result;
    }
}
