// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.TeamworkUserIdentity;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Chat Mark Chat Unread For User Parameter Set.
 */
public class ChatMarkChatUnreadForUserParameterSet {
    /**
     * The user.
     * 
     */
    @SerializedName(value = "user", alternate = {"User"})
    @Expose
	@Nullable
    public TeamworkUserIdentity user;

    /**
     * The last Message Read Date Time.
     * 
     */
    @SerializedName(value = "lastMessageReadDateTime", alternate = {"LastMessageReadDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastMessageReadDateTime;


    /**
     * Instiaciates a new ChatMarkChatUnreadForUserParameterSet
     */
    public ChatMarkChatUnreadForUserParameterSet() {}
    /**
     * Instiaciates a new ChatMarkChatUnreadForUserParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ChatMarkChatUnreadForUserParameterSet(@Nonnull final ChatMarkChatUnreadForUserParameterSetBuilder builder) {
        this.user = builder.user;
        this.lastMessageReadDateTime = builder.lastMessageReadDateTime;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ChatMarkChatUnreadForUserParameterSetBuilder newBuilder() {
        return new ChatMarkChatUnreadForUserParameterSetBuilder();
    }
    /**
     * Fluent builder for the ChatMarkChatUnreadForUserParameterSet
     */
    public static final class ChatMarkChatUnreadForUserParameterSetBuilder {
        /**
         * The user parameter value
         */
        @Nullable
        protected TeamworkUserIdentity user;
        /**
         * Sets the User
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ChatMarkChatUnreadForUserParameterSetBuilder withUser(@Nullable final TeamworkUserIdentity val) {
            this.user = val;
            return this;
        }
        /**
         * The lastMessageReadDateTime parameter value
         */
        @Nullable
        protected java.time.OffsetDateTime lastMessageReadDateTime;
        /**
         * Sets the LastMessageReadDateTime
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ChatMarkChatUnreadForUserParameterSetBuilder withLastMessageReadDateTime(@Nullable final java.time.OffsetDateTime val) {
            this.lastMessageReadDateTime = val;
            return this;
        }
        /**
         * Instanciates a new ChatMarkChatUnreadForUserParameterSetBuilder
         */
        @Nullable
        protected ChatMarkChatUnreadForUserParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ChatMarkChatUnreadForUserParameterSet build() {
            return new ChatMarkChatUnreadForUserParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.user != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("user", user));
        }
        if(this.lastMessageReadDateTime != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("lastMessageReadDateTime", lastMessageReadDateTime));
        }
        return result;
    }
}
