// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.DeviceLocalCredential;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Local Credential Info.
 */
public class DeviceLocalCredentialInfo extends Entity implements IJsonBackedObject {


    /**
     * The Credentials.
     * The credentials of the device's local administrator account backed up to Azure Active Directory.
     */
    @SerializedName(value = "credentials", alternate = {"Credentials"})
    @Expose
	@Nullable
    public java.util.List<DeviceLocalCredential> credentials;

    /**
     * The Device Name.
     * Display name of the device that the local credentials are associated with.
     */
    @SerializedName(value = "deviceName", alternate = {"DeviceName"})
    @Expose
	@Nullable
    public String deviceName;

    /**
     * The Last Backup Date Time.
     * When the local administrator account credential was backed up to Azure Active Directory.
     */
    @SerializedName(value = "lastBackupDateTime", alternate = {"LastBackupDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastBackupDateTime;

    /**
     * The Refresh Date Time.
     * When the local administrator account credential will be refreshed and backed up to Azure Active Directory.
     */
    @SerializedName(value = "refreshDateTime", alternate = {"RefreshDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime refreshDateTime;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
