// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.DomainDnsRecord;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Domain Dns Mx Record.
 */
public class DomainDnsMxRecord extends DomainDnsRecord implements IJsonBackedObject {


    /**
     * The Mail Exchange.
     * Value used when configuring the answer/destination/value of the MX record at the DNS host.
     */
    @SerializedName(value = "mailExchange", alternate = {"MailExchange"})
    @Expose
	@Nullable
    public String mailExchange;

    /**
     * The Preference.
     * Value used when configuring the Preference/Priority property of the MX record at the DNS host.
     */
    @SerializedName(value = "preference", alternate = {"Preference"})
    @Expose
	@Nullable
    public Integer preference;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
