// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.EmailIdentity;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the End User Notification Detail.
 */
public class EndUserNotificationDetail extends Entity implements IJsonBackedObject {


    /**
     * The Email Content.
     * Email HTML content.
     */
    @SerializedName(value = "emailContent", alternate = {"EmailContent"})
    @Expose
	@Nullable
    public String emailContent;

    /**
     * The Is Default Langauge.
     * Indicates whether this language is default.
     */
    @SerializedName(value = "isDefaultLangauge", alternate = {"IsDefaultLangauge"})
    @Expose
	@Nullable
    public Boolean isDefaultLangauge;

    /**
     * The Language.
     * Notification language.
     */
    @SerializedName(value = "language", alternate = {"Language"})
    @Expose
	@Nullable
    public String language;

    /**
     * The Locale.
     * Notification locale.
     */
    @SerializedName(value = "locale", alternate = {"Locale"})
    @Expose
	@Nullable
    public String locale;

    /**
     * The Sent From.
     * Email details of the sender.
     */
    @SerializedName(value = "sentFrom", alternate = {"SentFrom"})
    @Expose
	@Nullable
    public EmailIdentity sentFrom;

    /**
     * The Subject.
     * Mail subject.
     */
    @SerializedName(value = "subject", alternate = {"Subject"})
    @Expose
	@Nullable
    public String subject;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
