// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.requests.RiskDetectionCollectionPage;
import com.microsoft.graph.requests.RiskyServicePrincipalCollectionPage;
import com.microsoft.graph.requests.RiskyUserCollectionPage;
import com.microsoft.graph.requests.ServicePrincipalRiskDetectionCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Identity Protection Root.
 */
public class IdentityProtectionRoot implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Risk Detections.
     * Risk detection in Microsoft Entra ID Protection and the associated information about the detection.
     */
    @SerializedName(value = "riskDetections", alternate = {"RiskDetections"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.RiskDetectionCollectionPage riskDetections;

    /**
     * The Risky Service Principals.
     * Microsoft Entra service principals that are at risk.
     */
    @SerializedName(value = "riskyServicePrincipals", alternate = {"RiskyServicePrincipals"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.RiskyServicePrincipalCollectionPage riskyServicePrincipals;

    /**
     * The Risky Users.
     * Users that are flagged as at-risk by Microsoft Entra ID Protection.
     */
    @SerializedName(value = "riskyUsers", alternate = {"RiskyUsers"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.RiskyUserCollectionPage riskyUsers;

    /**
     * The Service Principal Risk Detections.
     * Represents information about detected at-risk service principals in a Microsoft Entra tenant.
     */
    @SerializedName(value = "servicePrincipalRiskDetections", alternate = {"ServicePrincipalRiskDetections"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.ServicePrincipalRiskDetectionCollectionPage servicePrincipalRiskDetections;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("riskDetections")) {
            riskDetections = serializer.deserializeObject(json.get("riskDetections"), com.microsoft.graph.requests.RiskDetectionCollectionPage.class);
        }

        if (json.has("riskyServicePrincipals")) {
            riskyServicePrincipals = serializer.deserializeObject(json.get("riskyServicePrincipals"), com.microsoft.graph.requests.RiskyServicePrincipalCollectionPage.class);
        }

        if (json.has("riskyUsers")) {
            riskyUsers = serializer.deserializeObject(json.get("riskyUsers"), com.microsoft.graph.requests.RiskyUserCollectionPage.class);
        }

        if (json.has("servicePrincipalRiskDetections")) {
            servicePrincipalRiskDetections = serializer.deserializeObject(json.get("servicePrincipalRiskDetections"), com.microsoft.graph.requests.ServicePrincipalRiskDetectionCollectionPage.class);
        }
    }
}
