// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Join Meeting Id Settings.
 */
public class JoinMeetingIdSettings implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Is Passcode Required.
     * Indicates whether a passcode is required to join a meeting when using joinMeetingId. Optional.
     */
    @SerializedName(value = "isPasscodeRequired", alternate = {"IsPasscodeRequired"})
    @Expose
	@Nullable
    public Boolean isPasscodeRequired;

    /**
     * The Join Meeting Id.
     * The meeting ID to be used to join a meeting. Optional. Read-only.
     */
    @SerializedName(value = "joinMeetingId", alternate = {"JoinMeetingId"})
    @Expose
	@Nullable
    public String joinMeetingId;

    /**
     * The Passcode.
     * The passcode to join a meeting.  Optional. Read-only.
     */
    @SerializedName(value = "passcode", alternate = {"Passcode"})
    @Expose
	@Nullable
    public String passcode;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
