// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AutomaticRepliesMailTips;
import com.microsoft.graph.models.EmailAddress;
import com.microsoft.graph.models.MailTipsError;
import com.microsoft.graph.models.RecipientScopeType;
import com.microsoft.graph.models.Recipient;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mail Tips.
 */
public class MailTips implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Automatic Replies.
     * Mail tips for automatic reply if it has been set up by the recipient.
     */
    @SerializedName(value = "automaticReplies", alternate = {"AutomaticReplies"})
    @Expose
	@Nullable
    public AutomaticRepliesMailTips automaticReplies;

    /**
     * The Custom Mail Tip.
     * A custom mail tip that can be set on the recipient's mailbox.
     */
    @SerializedName(value = "customMailTip", alternate = {"CustomMailTip"})
    @Expose
	@Nullable
    public String customMailTip;

    /**
     * The Delivery Restricted.
     * Whether the recipient's mailbox is restricted, for example, accepting messages from only a predefined list of senders, rejecting messages from a predefined list of senders, or accepting messages from only authenticated senders.
     */
    @SerializedName(value = "deliveryRestricted", alternate = {"DeliveryRestricted"})
    @Expose
	@Nullable
    public Boolean deliveryRestricted;

    /**
     * The Email Address.
     * The email address of the recipient to get mailtips for.
     */
    @SerializedName(value = "emailAddress", alternate = {"EmailAddress"})
    @Expose
	@Nullable
    public EmailAddress emailAddress;

    /**
     * The Error.
     * Errors that occur during the getMailTips action.
     */
    @SerializedName(value = "error", alternate = {"Error"})
    @Expose
	@Nullable
    public MailTipsError error;

    /**
     * The External Member Count.
     * The number of external members if the recipient is a distribution list.
     */
    @SerializedName(value = "externalMemberCount", alternate = {"ExternalMemberCount"})
    @Expose
	@Nullable
    public Integer externalMemberCount;

    /**
     * The Is Moderated.
     * Whether sending messages to the recipient requires approval. For example, if the recipient is a large distribution list and a moderator has been set up to approve messages sent to that distribution list, or if sending messages to a recipient requires approval of the recipient's manager.
     */
    @SerializedName(value = "isModerated", alternate = {"IsModerated"})
    @Expose
	@Nullable
    public Boolean isModerated;

    /**
     * The Mailbox Full.
     * The mailbox full status of the recipient.
     */
    @SerializedName(value = "mailboxFull", alternate = {"MailboxFull"})
    @Expose
	@Nullable
    public Boolean mailboxFull;

    /**
     * The Max Message Size.
     * The maximum message size that has been configured for the recipient's organization or mailbox.
     */
    @SerializedName(value = "maxMessageSize", alternate = {"MaxMessageSize"})
    @Expose
	@Nullable
    public Integer maxMessageSize;

    /**
     * The Recipient Scope.
     * The scope of the recipient. Possible values are: none, internal, external, externalPartner, externalNonParther. For example, an administrator can set another organization to be its 'partner'. The scope is useful if an administrator wants certain mailtips to be accessible to certain scopes. It's also useful to senders to inform them that their message may leave the organization, helping them make the correct decisions about wording, tone and content.
     */
    @SerializedName(value = "recipientScope", alternate = {"RecipientScope"})
    @Expose
	@Nullable
    public EnumSet<RecipientScopeType> recipientScope;

    /**
     * The Recipient Suggestions.
     * Recipients suggested based on previous contexts where they appear in the same message.
     */
    @SerializedName(value = "recipientSuggestions", alternate = {"RecipientSuggestions"})
    @Expose
	@Nullable
    public java.util.List<Recipient> recipientSuggestions;

    /**
     * The Total Member Count.
     * The number of members if the recipient is a distribution list.
     */
    @SerializedName(value = "totalMemberCount", alternate = {"TotalMemberCount"})
    @Expose
	@Nullable
    public Integer totalMemberCount;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
