// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.AttendanceRecordCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Meeting Attendance Report.
 */
public class MeetingAttendanceReport extends Entity implements IJsonBackedObject {


    /**
     * The Meeting End Date Time.
     * UTC time when the meeting ended. Read-only.
     */
    @SerializedName(value = "meetingEndDateTime", alternate = {"MeetingEndDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime meetingEndDateTime;

    /**
     * The Meeting Start Date Time.
     * UTC time when the meeting started. Read-only.
     */
    @SerializedName(value = "meetingStartDateTime", alternate = {"MeetingStartDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime meetingStartDateTime;

    /**
     * The Total Participant Count.
     * Total number of participants. Read-only.
     */
    @SerializedName(value = "totalParticipantCount", alternate = {"TotalParticipantCount"})
    @Expose
	@Nullable
    public Integer totalParticipantCount;

    /**
     * The Attendance Records.
     * List of attendance records of an attendance report. Read-only.
     */
    @SerializedName(value = "attendanceRecords", alternate = {"AttendanceRecords"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.AttendanceRecordCollectionPage attendanceRecords;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("attendanceRecords")) {
            attendanceRecords = serializer.deserializeObject(json.get("attendanceRecords"), com.microsoft.graph.requests.AttendanceRecordCollectionPage.class);
        }
    }
}
