// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.Message;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Message Move Parameter Set.
 */
public class MessageMoveParameterSet {
    /**
     * The destination Id.
     * 
     */
    @SerializedName(value = "destinationId", alternate = {"DestinationId"})
    @Expose
	@Nullable
    public String destinationId;


    /**
     * Instiaciates a new MessageMoveParameterSet
     */
    public MessageMoveParameterSet() {}
    /**
     * Instiaciates a new MessageMoveParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected MessageMoveParameterSet(@Nonnull final MessageMoveParameterSetBuilder builder) {
        this.destinationId = builder.destinationId;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static MessageMoveParameterSetBuilder newBuilder() {
        return new MessageMoveParameterSetBuilder();
    }
    /**
     * Fluent builder for the MessageMoveParameterSet
     */
    public static final class MessageMoveParameterSetBuilder {
        /**
         * The destinationId parameter value
         */
        @Nullable
        protected String destinationId;
        /**
         * Sets the DestinationId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public MessageMoveParameterSetBuilder withDestinationId(@Nullable final String val) {
            this.destinationId = val;
            return this;
        }
        /**
         * Instanciates a new MessageMoveParameterSetBuilder
         */
        @Nullable
        protected MessageMoveParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public MessageMoveParameterSet build() {
            return new MessageMoveParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.destinationId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("destinationId", destinationId));
        }
        return result;
    }
}
