// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.OpenShiftItem;
import com.microsoft.graph.models.ChangeTrackedEntity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Open Shift.
 */
public class OpenShift extends ChangeTrackedEntity implements IJsonBackedObject {


    /**
     * The Draft Open Shift.
     * An unpublished open shift.
     */
    @SerializedName(value = "draftOpenShift", alternate = {"DraftOpenShift"})
    @Expose
	@Nullable
    public OpenShiftItem draftOpenShift;

    /**
     * The Scheduling Group Id.
     * ID for the scheduling group that the open shift belongs to.
     */
    @SerializedName(value = "schedulingGroupId", alternate = {"SchedulingGroupId"})
    @Expose
	@Nullable
    public String schedulingGroupId;

    /**
     * The Shared Open Shift.
     * A published open shift.
     */
    @SerializedName(value = "sharedOpenShift", alternate = {"SharedOpenShift"})
    @Expose
	@Nullable
    public OpenShiftItem sharedOpenShift;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
