// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.Prompt;
import com.microsoft.graph.models.StartHoldMusicOperation;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Participant Start Hold Music Parameter Set.
 */
public class ParticipantStartHoldMusicParameterSet {
    /**
     * The custom Prompt.
     * 
     */
    @SerializedName(value = "customPrompt", alternate = {"CustomPrompt"})
    @Expose
	@Nullable
    public Prompt customPrompt;

    /**
     * The client Context.
     * 
     */
    @SerializedName(value = "clientContext", alternate = {"ClientContext"})
    @Expose
	@Nullable
    public String clientContext;


    /**
     * Instiaciates a new ParticipantStartHoldMusicParameterSet
     */
    public ParticipantStartHoldMusicParameterSet() {}
    /**
     * Instiaciates a new ParticipantStartHoldMusicParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ParticipantStartHoldMusicParameterSet(@Nonnull final ParticipantStartHoldMusicParameterSetBuilder builder) {
        this.customPrompt = builder.customPrompt;
        this.clientContext = builder.clientContext;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ParticipantStartHoldMusicParameterSetBuilder newBuilder() {
        return new ParticipantStartHoldMusicParameterSetBuilder();
    }
    /**
     * Fluent builder for the ParticipantStartHoldMusicParameterSet
     */
    public static final class ParticipantStartHoldMusicParameterSetBuilder {
        /**
         * The customPrompt parameter value
         */
        @Nullable
        protected Prompt customPrompt;
        /**
         * Sets the CustomPrompt
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ParticipantStartHoldMusicParameterSetBuilder withCustomPrompt(@Nullable final Prompt val) {
            this.customPrompt = val;
            return this;
        }
        /**
         * The clientContext parameter value
         */
        @Nullable
        protected String clientContext;
        /**
         * Sets the ClientContext
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ParticipantStartHoldMusicParameterSetBuilder withClientContext(@Nullable final String val) {
            this.clientContext = val;
            return this;
        }
        /**
         * Instanciates a new ParticipantStartHoldMusicParameterSetBuilder
         */
        @Nullable
        protected ParticipantStartHoldMusicParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ParticipantStartHoldMusicParameterSet build() {
            return new ParticipantStartHoldMusicParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.customPrompt != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("customPrompt", customPrompt));
        }
        if(this.clientContext != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("clientContext", clientContext));
        }
        return result;
    }
}
