// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.PresenceStatusMessage;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Presence Set Status Message Parameter Set.
 */
public class PresenceSetStatusMessageParameterSet {
    /**
     * The status Message.
     * 
     */
    @SerializedName(value = "statusMessage", alternate = {"StatusMessage"})
    @Expose
	@Nullable
    public PresenceStatusMessage statusMessage;


    /**
     * Instiaciates a new PresenceSetStatusMessageParameterSet
     */
    public PresenceSetStatusMessageParameterSet() {}
    /**
     * Instiaciates a new PresenceSetStatusMessageParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected PresenceSetStatusMessageParameterSet(@Nonnull final PresenceSetStatusMessageParameterSetBuilder builder) {
        this.statusMessage = builder.statusMessage;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static PresenceSetStatusMessageParameterSetBuilder newBuilder() {
        return new PresenceSetStatusMessageParameterSetBuilder();
    }
    /**
     * Fluent builder for the PresenceSetStatusMessageParameterSet
     */
    public static final class PresenceSetStatusMessageParameterSetBuilder {
        /**
         * The statusMessage parameter value
         */
        @Nullable
        protected PresenceStatusMessage statusMessage;
        /**
         * Sets the StatusMessage
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public PresenceSetStatusMessageParameterSetBuilder withStatusMessage(@Nullable final PresenceStatusMessage val) {
            this.statusMessage = val;
            return this;
        }
        /**
         * Instanciates a new PresenceSetStatusMessageParameterSetBuilder
         */
        @Nullable
        protected PresenceSetStatusMessageParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public PresenceSetStatusMessageParameterSet build() {
            return new PresenceSetStatusMessageParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.statusMessage != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("statusMessage", statusMessage));
        }
        return result;
    }
}
