// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.PrintCertificateSigningRequest;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Printer Create Parameter Set.
 */
public class PrinterCreateParameterSet {
    /**
     * The display Name.
     * 
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The manufacturer.
     * 
     */
    @SerializedName(value = "manufacturer", alternate = {"Manufacturer"})
    @Expose
	@Nullable
    public String manufacturer;

    /**
     * The model.
     * 
     */
    @SerializedName(value = "model", alternate = {"Model"})
    @Expose
	@Nullable
    public String model;

    /**
     * The physical Device Id.
     * 
     */
    @SerializedName(value = "physicalDeviceId", alternate = {"PhysicalDeviceId"})
    @Expose
	@Nullable
    public String physicalDeviceId;

    /**
     * The has Physical Device.
     * 
     */
    @SerializedName(value = "hasPhysicalDevice", alternate = {"HasPhysicalDevice"})
    @Expose
	@Nullable
    public Boolean hasPhysicalDevice;

    /**
     * The certificate Signing Request.
     * 
     */
    @SerializedName(value = "certificateSigningRequest", alternate = {"CertificateSigningRequest"})
    @Expose
	@Nullable
    public PrintCertificateSigningRequest certificateSigningRequest;

    /**
     * The connector Id.
     * 
     */
    @SerializedName(value = "connectorId", alternate = {"ConnectorId"})
    @Expose
	@Nullable
    public String connectorId;


    /**
     * Instiaciates a new PrinterCreateParameterSet
     */
    public PrinterCreateParameterSet() {}
    /**
     * Instiaciates a new PrinterCreateParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected PrinterCreateParameterSet(@Nonnull final PrinterCreateParameterSetBuilder builder) {
        this.displayName = builder.displayName;
        this.manufacturer = builder.manufacturer;
        this.model = builder.model;
        this.physicalDeviceId = builder.physicalDeviceId;
        this.hasPhysicalDevice = builder.hasPhysicalDevice;
        this.certificateSigningRequest = builder.certificateSigningRequest;
        this.connectorId = builder.connectorId;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static PrinterCreateParameterSetBuilder newBuilder() {
        return new PrinterCreateParameterSetBuilder();
    }
    /**
     * Fluent builder for the PrinterCreateParameterSet
     */
    public static final class PrinterCreateParameterSetBuilder {
        /**
         * The displayName parameter value
         */
        @Nullable
        protected String displayName;
        /**
         * Sets the DisplayName
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public PrinterCreateParameterSetBuilder withDisplayName(@Nullable final String val) {
            this.displayName = val;
            return this;
        }
        /**
         * The manufacturer parameter value
         */
        @Nullable
        protected String manufacturer;
        /**
         * Sets the Manufacturer
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public PrinterCreateParameterSetBuilder withManufacturer(@Nullable final String val) {
            this.manufacturer = val;
            return this;
        }
        /**
         * The model parameter value
         */
        @Nullable
        protected String model;
        /**
         * Sets the Model
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public PrinterCreateParameterSetBuilder withModel(@Nullable final String val) {
            this.model = val;
            return this;
        }
        /**
         * The physicalDeviceId parameter value
         */
        @Nullable
        protected String physicalDeviceId;
        /**
         * Sets the PhysicalDeviceId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public PrinterCreateParameterSetBuilder withPhysicalDeviceId(@Nullable final String val) {
            this.physicalDeviceId = val;
            return this;
        }
        /**
         * The hasPhysicalDevice parameter value
         */
        @Nullable
        protected Boolean hasPhysicalDevice;
        /**
         * Sets the HasPhysicalDevice
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public PrinterCreateParameterSetBuilder withHasPhysicalDevice(@Nullable final Boolean val) {
            this.hasPhysicalDevice = val;
            return this;
        }
        /**
         * The certificateSigningRequest parameter value
         */
        @Nullable
        protected PrintCertificateSigningRequest certificateSigningRequest;
        /**
         * Sets the CertificateSigningRequest
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public PrinterCreateParameterSetBuilder withCertificateSigningRequest(@Nullable final PrintCertificateSigningRequest val) {
            this.certificateSigningRequest = val;
            return this;
        }
        /**
         * The connectorId parameter value
         */
        @Nullable
        protected String connectorId;
        /**
         * Sets the ConnectorId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public PrinterCreateParameterSetBuilder withConnectorId(@Nullable final String val) {
            this.connectorId = val;
            return this;
        }
        /**
         * Instanciates a new PrinterCreateParameterSetBuilder
         */
        @Nullable
        protected PrinterCreateParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public PrinterCreateParameterSet build() {
            return new PrinterCreateParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.displayName != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("displayName", displayName));
        }
        if(this.manufacturer != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("manufacturer", manufacturer));
        }
        if(this.model != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("model", model));
        }
        if(this.physicalDeviceId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("physicalDeviceId", physicalDeviceId));
        }
        if(this.hasPhysicalDevice != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("hasPhysicalDevice", hasPhysicalDevice));
        }
        if(this.certificateSigningRequest != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("certificateSigningRequest", certificateSigningRequest));
        }
        if(this.connectorId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("connectorId", connectorId));
        }
        return result;
    }
}
