// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Resource Visualization.
 */
public class ResourceVisualization implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Container Display Name.
     * A string describing where the item is stored. For example, the name of a SharePoint site or the user name identifying the owner of the OneDrive storing the item.
     */
    @SerializedName(value = "containerDisplayName", alternate = {"ContainerDisplayName"})
    @Expose
	@Nullable
    public String containerDisplayName;

    /**
     * The Container Type.
     * Can be used for filtering by the type of container in which the file is stored. Such as Site or OneDriveBusiness.
     */
    @SerializedName(value = "containerType", alternate = {"ContainerType"})
    @Expose
	@Nullable
    public String containerType;

    /**
     * The Container Web Url.
     * A path leading to the folder in which the item is stored.
     */
    @SerializedName(value = "containerWebUrl", alternate = {"ContainerWebUrl"})
    @Expose
	@Nullable
    public String containerWebUrl;

    /**
     * The Media Type.
     * The item's media type. Can be used for filtering for a specific type of file based on supported IANA Media Mime Types. Not all Media Mime Types are supported.
     */
    @SerializedName(value = "mediaType", alternate = {"MediaType"})
    @Expose
	@Nullable
    public String mediaType;

    /**
     * The Preview Image Url.
     * A URL leading to the preview image for the item.
     */
    @SerializedName(value = "previewImageUrl", alternate = {"PreviewImageUrl"})
    @Expose
	@Nullable
    public String previewImageUrl;

    /**
     * The Preview Text.
     * A preview text for the item.
     */
    @SerializedName(value = "previewText", alternate = {"PreviewText"})
    @Expose
	@Nullable
    public String previewText;

    /**
     * The Title.
     * The item's title text.
     */
    @SerializedName(value = "title", alternate = {"Title"})
    @Expose
	@Nullable
    public String title;

    /**
     * The Type.
     * The item's media type. Can be used for filtering for a specific file based on a specific type. See the section Type property values for supported types.
     */
    @SerializedName(value = "type", alternate = {"Type"})
    @Expose
	@Nullable
    public String type;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
