// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Service Principal Lock Configuration.
 */
public class ServicePrincipalLockConfiguration implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The All Properties.
     * Enables locking all sensitive properties. The sensitive properties are keyCredentials, passwordCredentials, and tokenEncryptionKeyId.
     */
    @SerializedName(value = "allProperties", alternate = {"AllProperties"})
    @Expose
	@Nullable
    public Boolean allProperties;

    /**
     * The Credentials With Usage Sign.
     * Locks the keyCredentials and passwordCredentials properties for modification where credential usage type is Sign.
     */
    @SerializedName(value = "credentialsWithUsageSign", alternate = {"CredentialsWithUsageSign"})
    @Expose
	@Nullable
    public Boolean credentialsWithUsageSign;

    /**
     * The Credentials With Usage Verify.
     * Locks the keyCredentials and passwordCredentials properties for modification where credential usage type is Verify. This locks OAuth service principals.
     */
    @SerializedName(value = "credentialsWithUsageVerify", alternate = {"CredentialsWithUsageVerify"})
    @Expose
	@Nullable
    public Boolean credentialsWithUsageVerify;

    /**
     * The Is Enabled.
     * Enables or disables service principal lock configuration. To allow the sensitive properties to be updated, update this property to false to disable the lock on the service principal.
     */
    @SerializedName(value = "isEnabled", alternate = {"IsEnabled"})
    @Expose
	@Nullable
    public Boolean isEnabled;

    /**
     * The Token Encryption Key Id.
     * Locks the tokenEncryptionKeyId property for modification on the service principal.
     */
    @SerializedName(value = "tokenEncryptionKeyId", alternate = {"TokenEncryptionKeyId"})
    @Expose
	@Nullable
    public Boolean tokenEncryptionKeyId;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
