// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Software Update Status Summary.
 */
public class SoftwareUpdateStatusSummary extends Entity implements IJsonBackedObject {


    /**
     * The Compliant Device Count.
     * Number of compliant devices.
     */
    @SerializedName(value = "compliantDeviceCount", alternate = {"CompliantDeviceCount"})
    @Expose
	@Nullable
    public Integer compliantDeviceCount;

    /**
     * The Compliant User Count.
     * Number of compliant users.
     */
    @SerializedName(value = "compliantUserCount", alternate = {"CompliantUserCount"})
    @Expose
	@Nullable
    public Integer compliantUserCount;

    /**
     * The Conflict Device Count.
     * Number of conflict devices.
     */
    @SerializedName(value = "conflictDeviceCount", alternate = {"ConflictDeviceCount"})
    @Expose
	@Nullable
    public Integer conflictDeviceCount;

    /**
     * The Conflict User Count.
     * Number of conflict users.
     */
    @SerializedName(value = "conflictUserCount", alternate = {"ConflictUserCount"})
    @Expose
	@Nullable
    public Integer conflictUserCount;

    /**
     * The Display Name.
     * The name of the policy.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Error Device Count.
     * Number of devices had error.
     */
    @SerializedName(value = "errorDeviceCount", alternate = {"ErrorDeviceCount"})
    @Expose
	@Nullable
    public Integer errorDeviceCount;

    /**
     * The Error User Count.
     * Number of users had error.
     */
    @SerializedName(value = "errorUserCount", alternate = {"ErrorUserCount"})
    @Expose
	@Nullable
    public Integer errorUserCount;

    /**
     * The Non Compliant Device Count.
     * Number of non compliant devices.
     */
    @SerializedName(value = "nonCompliantDeviceCount", alternate = {"NonCompliantDeviceCount"})
    @Expose
	@Nullable
    public Integer nonCompliantDeviceCount;

    /**
     * The Non Compliant User Count.
     * Number of non compliant users.
     */
    @SerializedName(value = "nonCompliantUserCount", alternate = {"NonCompliantUserCount"})
    @Expose
	@Nullable
    public Integer nonCompliantUserCount;

    /**
     * The Not Applicable Device Count.
     * Number of not applicable devices.
     */
    @SerializedName(value = "notApplicableDeviceCount", alternate = {"NotApplicableDeviceCount"})
    @Expose
	@Nullable
    public Integer notApplicableDeviceCount;

    /**
     * The Not Applicable User Count.
     * Number of not applicable users.
     */
    @SerializedName(value = "notApplicableUserCount", alternate = {"NotApplicableUserCount"})
    @Expose
	@Nullable
    public Integer notApplicableUserCount;

    /**
     * The Remediated Device Count.
     * Number of remediated devices.
     */
    @SerializedName(value = "remediatedDeviceCount", alternate = {"RemediatedDeviceCount"})
    @Expose
	@Nullable
    public Integer remediatedDeviceCount;

    /**
     * The Remediated User Count.
     * Number of remediated users.
     */
    @SerializedName(value = "remediatedUserCount", alternate = {"RemediatedUserCount"})
    @Expose
	@Nullable
    public Integer remediatedUserCount;

    /**
     * The Unknown Device Count.
     * Number of unknown devices.
     */
    @SerializedName(value = "unknownDeviceCount", alternate = {"UnknownDeviceCount"})
    @Expose
	@Nullable
    public Integer unknownDeviceCount;

    /**
     * The Unknown User Count.
     * Number of unknown users.
     */
    @SerializedName(value = "unknownUserCount", alternate = {"UnknownUserCount"})
    @Expose
	@Nullable
    public Integer unknownUserCount;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
