// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Experience Analytics Work From Anywhere Hardware Readiness Metric.
 */
public class UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric extends Entity implements IJsonBackedObject {


    /**
     * The Os Check Failed Percentage.
     * The percentage of devices for which OS check has failed. Valid values 0 to 100. Supports: $select, $OrderBy. Read-only. Valid values -1.79769313486232E+308 to 1.79769313486232E+308
     */
    @SerializedName(value = "osCheckFailedPercentage", alternate = {"OsCheckFailedPercentage"})
    @Expose
	@Nullable
    public Double osCheckFailedPercentage;

    /**
     * The Processor64Bit Check Failed Percentage.
     * The percentage of devices for which processor hardware 64-bit architecture check has failed. Valid values 0 to 100. Supports: $select, $OrderBy. Read-only. Valid values -1.79769313486232E+308 to 1.79769313486232E+308
     */
    @SerializedName(value = "processor64BitCheckFailedPercentage", alternate = {"Processor64BitCheckFailedPercentage"})
    @Expose
	@Nullable
    public Double processor64BitCheckFailedPercentage;

    /**
     * The Processor Core Count Check Failed Percentage.
     * The percentage of devices for which processor hardware core count check has failed. Valid values 0 to 100. Supports: $select, $OrderBy. Read-only. Valid values -1.79769313486232E+308 to 1.79769313486232E+308
     */
    @SerializedName(value = "processorCoreCountCheckFailedPercentage", alternate = {"ProcessorCoreCountCheckFailedPercentage"})
    @Expose
	@Nullable
    public Double processorCoreCountCheckFailedPercentage;

    /**
     * The Processor Family Check Failed Percentage.
     * The percentage of devices for which processor hardware family check has failed. Valid values 0 to 100. Supports: $select, $OrderBy. Read-only. Valid values -1.79769313486232E+308 to 1.79769313486232E+308
     */
    @SerializedName(value = "processorFamilyCheckFailedPercentage", alternate = {"ProcessorFamilyCheckFailedPercentage"})
    @Expose
	@Nullable
    public Double processorFamilyCheckFailedPercentage;

    /**
     * The Processor Speed Check Failed Percentage.
     * The percentage of devices for which processor hardware speed check has failed. Valid values 0 to 100. Supports: $select, $OrderBy. Read-only. Valid values -1.79769313486232E+308 to 1.79769313486232E+308
     */
    @SerializedName(value = "processorSpeedCheckFailedPercentage", alternate = {"ProcessorSpeedCheckFailedPercentage"})
    @Expose
	@Nullable
    public Double processorSpeedCheckFailedPercentage;

    /**
     * The Ram Check Failed Percentage.
     * The percentage of devices for which RAM hardware check has failed. Valid values 0 to 100. Supports: $select, $OrderBy. Read-only. Valid values -1.79769313486232E+308 to 1.79769313486232E+308
     */
    @SerializedName(value = "ramCheckFailedPercentage", alternate = {"RamCheckFailedPercentage"})
    @Expose
	@Nullable
    public Double ramCheckFailedPercentage;

    /**
     * The Secure Boot Check Failed Percentage.
     * The percentage of devices for which secure boot hardware check has failed. Valid values 0 to 100. Supports: $select, $OrderBy. Read-only. Valid values -1.79769313486232E+308 to 1.79769313486232E+308
     */
    @SerializedName(value = "secureBootCheckFailedPercentage", alternate = {"SecureBootCheckFailedPercentage"})
    @Expose
	@Nullable
    public Double secureBootCheckFailedPercentage;

    /**
     * The Storage Check Failed Percentage.
     * The percentage of devices for which storage hardware check has failed. Valid values 0 to 100. Supports: $select, $OrderBy. Read-only. Valid values -1.79769313486232E+308 to 1.79769313486232E+308
     */
    @SerializedName(value = "storageCheckFailedPercentage", alternate = {"StorageCheckFailedPercentage"})
    @Expose
	@Nullable
    public Double storageCheckFailedPercentage;

    /**
     * The Total Device Count.
     * The count of total devices in an organization. Valid values 0 to 2147483647. Supports: $select, $OrderBy. Read-only. Valid values -2147483648 to 2147483647
     */
    @SerializedName(value = "totalDeviceCount", alternate = {"TotalDeviceCount"})
    @Expose
	@Nullable
    public Integer totalDeviceCount;

    /**
     * The Tpm Check Failed Percentage.
     * The percentage of devices for which Trusted Platform Module (TPM) hardware check has failed. Valid values 0 to 100. Supports: $select, $OrderBy. Read-only. Valid values -1.79769313486232E+308 to 1.79769313486232E+308
     */
    @SerializedName(value = "tpmCheckFailedPercentage", alternate = {"TpmCheckFailedPercentage"})
    @Expose
	@Nullable
    public Double tpmCheckFailedPercentage;

    /**
     * The Upgrade Eligible Device Count.
     * The count of devices in an organization eligible for windows upgrade. Valid values 0 to 2147483647. Supports: $select, $OrderBy. Read-only. Valid values -2147483648 to 2147483647
     */
    @SerializedName(value = "upgradeEligibleDeviceCount", alternate = {"UpgradeEligibleDeviceCount"})
    @Expose
	@Nullable
    public Integer upgradeEligibleDeviceCount;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
