// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Count Blank Parameter Set.
 */
public class WorkbookFunctionsCountBlankParameterSet {
    /**
     * The range.
     * 
     */
    @SerializedName(value = "range", alternate = {"Range"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement range;


    /**
     * Instiaciates a new WorkbookFunctionsCountBlankParameterSet
     */
    public WorkbookFunctionsCountBlankParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsCountBlankParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsCountBlankParameterSet(@Nonnull final WorkbookFunctionsCountBlankParameterSetBuilder builder) {
        this.range = builder.range;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsCountBlankParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsCountBlankParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsCountBlankParameterSet
     */
    public static final class WorkbookFunctionsCountBlankParameterSetBuilder {
        /**
         * The range parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement range;
        /**
         * Sets the Range
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsCountBlankParameterSetBuilder withRange(@Nullable final com.google.gson.JsonElement val) {
            this.range = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsCountBlankParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsCountBlankParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsCountBlankParameterSet build() {
            return new WorkbookFunctionsCountBlankParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.range != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("range", range));
        }
        return result;
    }
}
