// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Eo Month Parameter Set.
 */
public class WorkbookFunctionsEoMonthParameterSet {
    /**
     * The start Date.
     * 
     */
    @SerializedName(value = "startDate", alternate = {"StartDate"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement startDate;

    /**
     * The months.
     * 
     */
    @SerializedName(value = "months", alternate = {"Months"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement months;


    /**
     * Instiaciates a new WorkbookFunctionsEoMonthParameterSet
     */
    public WorkbookFunctionsEoMonthParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsEoMonthParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsEoMonthParameterSet(@Nonnull final WorkbookFunctionsEoMonthParameterSetBuilder builder) {
        this.startDate = builder.startDate;
        this.months = builder.months;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsEoMonthParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsEoMonthParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsEoMonthParameterSet
     */
    public static final class WorkbookFunctionsEoMonthParameterSetBuilder {
        /**
         * The startDate parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement startDate;
        /**
         * Sets the StartDate
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsEoMonthParameterSetBuilder withStartDate(@Nullable final com.google.gson.JsonElement val) {
            this.startDate = val;
            return this;
        }
        /**
         * The months parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement months;
        /**
         * Sets the Months
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsEoMonthParameterSetBuilder withMonths(@Nullable final com.google.gson.JsonElement val) {
            this.months = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsEoMonthParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsEoMonthParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsEoMonthParameterSet build() {
            return new WorkbookFunctionsEoMonthParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.startDate != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("startDate", startDate));
        }
        if(this.months != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("months", months));
        }
        return result;
    }
}
