// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Leftb Parameter Set.
 */
public class WorkbookFunctionsLeftbParameterSet {
    /**
     * The text.
     * 
     */
    @SerializedName(value = "text", alternate = {"Text"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement text;

    /**
     * The num Bytes.
     * 
     */
    @SerializedName(value = "numBytes", alternate = {"NumBytes"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement numBytes;


    /**
     * Instiaciates a new WorkbookFunctionsLeftbParameterSet
     */
    public WorkbookFunctionsLeftbParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsLeftbParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsLeftbParameterSet(@Nonnull final WorkbookFunctionsLeftbParameterSetBuilder builder) {
        this.text = builder.text;
        this.numBytes = builder.numBytes;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsLeftbParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsLeftbParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsLeftbParameterSet
     */
    public static final class WorkbookFunctionsLeftbParameterSetBuilder {
        /**
         * The text parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement text;
        /**
         * Sets the Text
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsLeftbParameterSetBuilder withText(@Nullable final com.google.gson.JsonElement val) {
            this.text = val;
            return this;
        }
        /**
         * The numBytes parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement numBytes;
        /**
         * Sets the NumBytes
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsLeftbParameterSetBuilder withNumBytes(@Nullable final com.google.gson.JsonElement val) {
            this.numBytes = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsLeftbParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsLeftbParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsLeftbParameterSet build() {
            return new WorkbookFunctionsLeftbParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.text != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("text", text));
        }
        if(this.numBytes != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("numBytes", numBytes));
        }
        return result;
    }
}
