// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Tbill Eq Parameter Set.
 */
public class WorkbookFunctionsTbillEqParameterSet {
    /**
     * The settlement.
     * 
     */
    @SerializedName(value = "settlement", alternate = {"Settlement"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement settlement;

    /**
     * The maturity.
     * 
     */
    @SerializedName(value = "maturity", alternate = {"Maturity"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement maturity;

    /**
     * The discount.
     * 
     */
    @SerializedName(value = "discount", alternate = {"Discount"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement discount;


    /**
     * Instiaciates a new WorkbookFunctionsTbillEqParameterSet
     */
    public WorkbookFunctionsTbillEqParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsTbillEqParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsTbillEqParameterSet(@Nonnull final WorkbookFunctionsTbillEqParameterSetBuilder builder) {
        this.settlement = builder.settlement;
        this.maturity = builder.maturity;
        this.discount = builder.discount;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsTbillEqParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsTbillEqParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsTbillEqParameterSet
     */
    public static final class WorkbookFunctionsTbillEqParameterSetBuilder {
        /**
         * The settlement parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement settlement;
        /**
         * Sets the Settlement
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsTbillEqParameterSetBuilder withSettlement(@Nullable final com.google.gson.JsonElement val) {
            this.settlement = val;
            return this;
        }
        /**
         * The maturity parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement maturity;
        /**
         * Sets the Maturity
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsTbillEqParameterSetBuilder withMaturity(@Nullable final com.google.gson.JsonElement val) {
            this.maturity = val;
            return this;
        }
        /**
         * The discount parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement discount;
        /**
         * Sets the Discount
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsTbillEqParameterSetBuilder withDiscount(@Nullable final com.google.gson.JsonElement val) {
            this.discount = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsTbillEqParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsTbillEqParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsTbillEqParameterSet build() {
            return new WorkbookFunctionsTbillEqParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.settlement != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("settlement", settlement));
        }
        if(this.maturity != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("maturity", maturity));
        }
        if(this.discount != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("discount", discount));
        }
        return result;
    }
}
