// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessPackageCatalog;
import com.microsoft.graph.models.AccessPackage;
import com.microsoft.graph.models.AccessPackageAssignmentRequestRequirements;
import com.microsoft.graph.models.AccessPackageFilterByCurrentUserOptions;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.AccessPackageCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.AccessPackageCollectionWithReferencesPage;
import com.microsoft.graph.requests.AccessPackageCollectionResponse;
import com.microsoft.graph.models.AccessPackage;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Collection With References Page.
 */
public class AccessPackageCollectionWithReferencesPage extends BaseCollectionPage<AccessPackage, AccessPackageCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for AccessPackage
     *
     * @param response the serialized AccessPackageCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public AccessPackageCollectionWithReferencesPage(@Nonnull final AccessPackageCollectionResponse response, @Nullable final AccessPackageCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for AccessPackage
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public AccessPackageCollectionWithReferencesPage(@Nonnull final java.util.List<AccessPackage> pageContents, @Nullable final AccessPackageCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
