// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessPackageResource;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Resource Request.
 */
public class AccessPackageResourceRequest extends BaseRequest<AccessPackageResource> {
	
    /**
     * The request for the AccessPackageResource
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessPackageResourceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessPackageResource.class);
    }

    /**
     * Gets the AccessPackageResource from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageResource> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AccessPackageResource from the service
     *
     * @return the AccessPackageResource from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageResource get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageResource> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AccessPackageResource delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AccessPackageResource with a source
     *
     * @param sourceAccessPackageResource the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageResource> patchAsync(@Nonnull final AccessPackageResource sourceAccessPackageResource) {
        return sendAsync(HttpMethod.PATCH, sourceAccessPackageResource);
    }

    /**
     * Patches this AccessPackageResource with a source
     *
     * @param sourceAccessPackageResource the source object with updates
     * @return the updated AccessPackageResource
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageResource patch(@Nonnull final AccessPackageResource sourceAccessPackageResource) throws ClientException {
        return send(HttpMethod.PATCH, sourceAccessPackageResource);
    }

    /**
     * Creates a AccessPackageResource with a new object
     *
     * @param newAccessPackageResource the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageResource> postAsync(@Nonnull final AccessPackageResource newAccessPackageResource) {
        return sendAsync(HttpMethod.POST, newAccessPackageResource);
    }

    /**
     * Creates a AccessPackageResource with a new object
     *
     * @param newAccessPackageResource the new object to create
     * @return the created AccessPackageResource
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageResource post(@Nonnull final AccessPackageResource newAccessPackageResource) throws ClientException {
        return send(HttpMethod.POST, newAccessPackageResource);
    }

    /**
     * Creates a AccessPackageResource with a new object
     *
     * @param newAccessPackageResource the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageResource> putAsync(@Nonnull final AccessPackageResource newAccessPackageResource) {
        return sendAsync(HttpMethod.PUT, newAccessPackageResource);
    }

    /**
     * Creates a AccessPackageResource with a new object
     *
     * @param newAccessPackageResource the object to create/update
     * @return the created AccessPackageResource
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageResource put(@Nonnull final AccessPackageResource newAccessPackageResource) throws ClientException {
        return send(HttpMethod.PUT, newAccessPackageResource);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AccessPackageResourceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AccessPackageResourceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

