// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AppleManagedIdentityProvider;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Apple Managed Identity Provider Request.
 */
public class AppleManagedIdentityProviderRequest extends BaseRequest<AppleManagedIdentityProvider> {
	
    /**
     * The request for the AppleManagedIdentityProvider
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AppleManagedIdentityProviderRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AppleManagedIdentityProvider.class);
    }

    /**
     * Gets the AppleManagedIdentityProvider from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppleManagedIdentityProvider> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AppleManagedIdentityProvider from the service
     *
     * @return the AppleManagedIdentityProvider from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AppleManagedIdentityProvider get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppleManagedIdentityProvider> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AppleManagedIdentityProvider delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AppleManagedIdentityProvider with a source
     *
     * @param sourceAppleManagedIdentityProvider the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppleManagedIdentityProvider> patchAsync(@Nonnull final AppleManagedIdentityProvider sourceAppleManagedIdentityProvider) {
        return sendAsync(HttpMethod.PATCH, sourceAppleManagedIdentityProvider);
    }

    /**
     * Patches this AppleManagedIdentityProvider with a source
     *
     * @param sourceAppleManagedIdentityProvider the source object with updates
     * @return the updated AppleManagedIdentityProvider
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AppleManagedIdentityProvider patch(@Nonnull final AppleManagedIdentityProvider sourceAppleManagedIdentityProvider) throws ClientException {
        return send(HttpMethod.PATCH, sourceAppleManagedIdentityProvider);
    }

    /**
     * Creates a AppleManagedIdentityProvider with a new object
     *
     * @param newAppleManagedIdentityProvider the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppleManagedIdentityProvider> postAsync(@Nonnull final AppleManagedIdentityProvider newAppleManagedIdentityProvider) {
        return sendAsync(HttpMethod.POST, newAppleManagedIdentityProvider);
    }

    /**
     * Creates a AppleManagedIdentityProvider with a new object
     *
     * @param newAppleManagedIdentityProvider the new object to create
     * @return the created AppleManagedIdentityProvider
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AppleManagedIdentityProvider post(@Nonnull final AppleManagedIdentityProvider newAppleManagedIdentityProvider) throws ClientException {
        return send(HttpMethod.POST, newAppleManagedIdentityProvider);
    }

    /**
     * Creates a AppleManagedIdentityProvider with a new object
     *
     * @param newAppleManagedIdentityProvider the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppleManagedIdentityProvider> putAsync(@Nonnull final AppleManagedIdentityProvider newAppleManagedIdentityProvider) {
        return sendAsync(HttpMethod.PUT, newAppleManagedIdentityProvider);
    }

    /**
     * Creates a AppleManagedIdentityProvider with a new object
     *
     * @param newAppleManagedIdentityProvider the object to create/update
     * @return the created AppleManagedIdentityProvider
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AppleManagedIdentityProvider put(@Nonnull final AppleManagedIdentityProvider newAppleManagedIdentityProvider) throws ClientException {
        return send(HttpMethod.PUT, newAppleManagedIdentityProvider);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AppleManagedIdentityProviderRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AppleManagedIdentityProviderRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

