// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Authentication;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Request Builder.
 */
public class AuthenticationRequestBuilder extends BaseRequestBuilder<Authentication> {

    /**
     * The request builder for the Authentication
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuthenticationRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the AuthenticationRequest instance
     */
    @Nonnull
    public AuthenticationRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the AuthenticationRequest instance
     */
    @Nonnull
    public AuthenticationRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.AuthenticationRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the EmailAuthenticationMethod collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.EmailAuthenticationMethodCollectionRequestBuilder emailMethods() {
        return new com.microsoft.graph.requests.EmailAuthenticationMethodCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("emailMethods"), getClient(), null);
    }

    /**
     * Gets a request builder for the EmailAuthenticationMethod item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.EmailAuthenticationMethodRequestBuilder emailMethods(@Nonnull final String id) {
        return new com.microsoft.graph.requests.EmailAuthenticationMethodRequestBuilder(getRequestUrlWithAdditionalSegment("emailMethods") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the Fido2AuthenticationMethod collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.Fido2AuthenticationMethodCollectionRequestBuilder fido2Methods() {
        return new com.microsoft.graph.requests.Fido2AuthenticationMethodCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("fido2Methods"), getClient(), null);
    }

    /**
     * Gets a request builder for the Fido2AuthenticationMethod item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.Fido2AuthenticationMethodRequestBuilder fido2Methods(@Nonnull final String id) {
        return new com.microsoft.graph.requests.Fido2AuthenticationMethodRequestBuilder(getRequestUrlWithAdditionalSegment("fido2Methods") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the AuthenticationMethod collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.AuthenticationMethodCollectionRequestBuilder methods() {
        return new com.microsoft.graph.requests.AuthenticationMethodCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("methods"), getClient(), null);
    }

    /**
     * Gets a request builder for the AuthenticationMethod item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.AuthenticationMethodRequestBuilder methods(@Nonnull final String id) {
        return new com.microsoft.graph.requests.AuthenticationMethodRequestBuilder(getRequestUrlWithAdditionalSegment("methods") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the MicrosoftAuthenticatorAuthenticationMethod collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.MicrosoftAuthenticatorAuthenticationMethodCollectionRequestBuilder microsoftAuthenticatorMethods() {
        return new com.microsoft.graph.requests.MicrosoftAuthenticatorAuthenticationMethodCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoftAuthenticatorMethods"), getClient(), null);
    }

    /**
     * Gets a request builder for the MicrosoftAuthenticatorAuthenticationMethod item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.MicrosoftAuthenticatorAuthenticationMethodRequestBuilder microsoftAuthenticatorMethods(@Nonnull final String id) {
        return new com.microsoft.graph.requests.MicrosoftAuthenticatorAuthenticationMethodRequestBuilder(getRequestUrlWithAdditionalSegment("microsoftAuthenticatorMethods") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the LongRunningOperation collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.LongRunningOperationCollectionRequestBuilder operations() {
        return new com.microsoft.graph.requests.LongRunningOperationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("operations"), getClient(), null);
    }

    /**
     * Gets a request builder for the LongRunningOperation item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.LongRunningOperationRequestBuilder operations(@Nonnull final String id) {
        return new com.microsoft.graph.requests.LongRunningOperationRequestBuilder(getRequestUrlWithAdditionalSegment("operations") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the PasswordAuthenticationMethod collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.PasswordAuthenticationMethodCollectionRequestBuilder passwordMethods() {
        return new com.microsoft.graph.requests.PasswordAuthenticationMethodCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("passwordMethods"), getClient(), null);
    }

    /**
     * Gets a request builder for the PasswordAuthenticationMethod item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.PasswordAuthenticationMethodRequestBuilder passwordMethods(@Nonnull final String id) {
        return new com.microsoft.graph.requests.PasswordAuthenticationMethodRequestBuilder(getRequestUrlWithAdditionalSegment("passwordMethods") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the PhoneAuthenticationMethod collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.PhoneAuthenticationMethodCollectionRequestBuilder phoneMethods() {
        return new com.microsoft.graph.requests.PhoneAuthenticationMethodCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("phoneMethods"), getClient(), null);
    }

    /**
     * Gets a request builder for the PhoneAuthenticationMethod item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.PhoneAuthenticationMethodRequestBuilder phoneMethods(@Nonnull final String id) {
        return new com.microsoft.graph.requests.PhoneAuthenticationMethodRequestBuilder(getRequestUrlWithAdditionalSegment("phoneMethods") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the SoftwareOathAuthenticationMethod collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.SoftwareOathAuthenticationMethodCollectionRequestBuilder softwareOathMethods() {
        return new com.microsoft.graph.requests.SoftwareOathAuthenticationMethodCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("softwareOathMethods"), getClient(), null);
    }

    /**
     * Gets a request builder for the SoftwareOathAuthenticationMethod item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.SoftwareOathAuthenticationMethodRequestBuilder softwareOathMethods(@Nonnull final String id) {
        return new com.microsoft.graph.requests.SoftwareOathAuthenticationMethodRequestBuilder(getRequestUrlWithAdditionalSegment("softwareOathMethods") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the TemporaryAccessPassAuthenticationMethod collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.TemporaryAccessPassAuthenticationMethodCollectionRequestBuilder temporaryAccessPassMethods() {
        return new com.microsoft.graph.requests.TemporaryAccessPassAuthenticationMethodCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("temporaryAccessPassMethods"), getClient(), null);
    }

    /**
     * Gets a request builder for the TemporaryAccessPassAuthenticationMethod item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.TemporaryAccessPassAuthenticationMethodRequestBuilder temporaryAccessPassMethods(@Nonnull final String id) {
        return new com.microsoft.graph.requests.TemporaryAccessPassAuthenticationMethodRequestBuilder(getRequestUrlWithAdditionalSegment("temporaryAccessPassMethods") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the WindowsHelloForBusinessAuthenticationMethod collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.WindowsHelloForBusinessAuthenticationMethodCollectionRequestBuilder windowsHelloForBusinessMethods() {
        return new com.microsoft.graph.requests.WindowsHelloForBusinessAuthenticationMethodCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("windowsHelloForBusinessMethods"), getClient(), null);
    }

    /**
     * Gets a request builder for the WindowsHelloForBusinessAuthenticationMethod item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.WindowsHelloForBusinessAuthenticationMethodRequestBuilder windowsHelloForBusinessMethods(@Nonnull final String id) {
        return new com.microsoft.graph.requests.WindowsHelloForBusinessAuthenticationMethodRequestBuilder(getRequestUrlWithAdditionalSegment("windowsHelloForBusinessMethods") + "/" + id, getClient(), null);
    }
}
