// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.CallRecording;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Call Recording Request.
 */
public class CallRecordingRequest extends BaseRequest<CallRecording> {
	
    /**
     * The request for the CallRecording
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CallRecordingRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, CallRecording.class);
    }

    /**
     * Gets the CallRecording from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CallRecording> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the CallRecording from the service
     *
     * @return the CallRecording from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CallRecording get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CallRecording> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public CallRecording delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this CallRecording with a source
     *
     * @param sourceCallRecording the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CallRecording> patchAsync(@Nonnull final CallRecording sourceCallRecording) {
        return sendAsync(HttpMethod.PATCH, sourceCallRecording);
    }

    /**
     * Patches this CallRecording with a source
     *
     * @param sourceCallRecording the source object with updates
     * @return the updated CallRecording
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CallRecording patch(@Nonnull final CallRecording sourceCallRecording) throws ClientException {
        return send(HttpMethod.PATCH, sourceCallRecording);
    }

    /**
     * Creates a CallRecording with a new object
     *
     * @param newCallRecording the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CallRecording> postAsync(@Nonnull final CallRecording newCallRecording) {
        return sendAsync(HttpMethod.POST, newCallRecording);
    }

    /**
     * Creates a CallRecording with a new object
     *
     * @param newCallRecording the new object to create
     * @return the created CallRecording
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CallRecording post(@Nonnull final CallRecording newCallRecording) throws ClientException {
        return send(HttpMethod.POST, newCallRecording);
    }

    /**
     * Creates a CallRecording with a new object
     *
     * @param newCallRecording the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CallRecording> putAsync(@Nonnull final CallRecording newCallRecording) {
        return sendAsync(HttpMethod.PUT, newCallRecording);
    }

    /**
     * Creates a CallRecording with a new object
     *
     * @param newCallRecording the object to create/update
     * @return the created CallRecording
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CallRecording put(@Nonnull final CallRecording newCallRecording) throws ClientException {
        return send(HttpMethod.PUT, newCallRecording);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public CallRecordingRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public CallRecordingRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

