// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Chat;
import com.microsoft.graph.models.TeamworkActivityTopic;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.KeyValuePair;
import com.microsoft.graph.models.TeamworkNotificationRecipient;
import com.microsoft.graph.models.TeamworkUserIdentity;
import com.microsoft.graph.models.ChatMessage;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.ChatSendActivityNotificationParameterSet;
import com.microsoft.graph.models.ChatHideForUserParameterSet;
import com.microsoft.graph.models.ChatMarkChatReadForUserParameterSet;
import com.microsoft.graph.models.ChatMarkChatUnreadForUserParameterSet;
import com.microsoft.graph.models.ChatUnhideForUserParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Chat Request Builder.
 */
public class ChatRequestBuilder extends BaseRequestBuilder<Chat> {

    /**
     * The request builder for the Chat
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ChatRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the ChatRequest instance
     */
    @Nonnull
    public ChatRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the ChatRequest instance
     */
    @Nonnull
    public ChatRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.ChatRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the TeamsAppInstallation collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.TeamsAppInstallationCollectionRequestBuilder installedApps() {
        return new com.microsoft.graph.requests.TeamsAppInstallationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("installedApps"), getClient(), null);
    }

    /**
     * Gets a request builder for the TeamsAppInstallation item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.TeamsAppInstallationRequestBuilder installedApps(@Nonnull final String id) {
        return new com.microsoft.graph.requests.TeamsAppInstallationRequestBuilder(getRequestUrlWithAdditionalSegment("installedApps") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for ChatMessageInfo
     *
     * @return the ChatMessageInfoRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.ChatMessageInfoRequestBuilder lastMessagePreview() {
        return new com.microsoft.graph.requests.ChatMessageInfoRequestBuilder(getRequestUrlWithAdditionalSegment("lastMessagePreview"), getClient(), null);
    }
    /**
     *  Gets a request builder for the ConversationMember collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ConversationMemberCollectionRequestBuilder members() {
        return new com.microsoft.graph.requests.ConversationMemberCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("members"), getClient(), null);
    }

    /**
     * Gets a request builder for the ConversationMember item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ConversationMemberRequestBuilder members(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ConversationMemberRequestBuilder(getRequestUrlWithAdditionalSegment("members") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the ChatMessage collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ChatMessageCollectionRequestBuilder messages() {
        return new com.microsoft.graph.requests.ChatMessageCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("messages"), getClient(), null);
    }

    /**
     * Gets a request builder for the ChatMessage item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ChatMessageRequestBuilder messages(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ChatMessageRequestBuilder(getRequestUrlWithAdditionalSegment("messages") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the ResourceSpecificPermissionGrant collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ResourceSpecificPermissionGrantCollectionRequestBuilder permissionGrants() {
        return new com.microsoft.graph.requests.ResourceSpecificPermissionGrantCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("permissionGrants"), getClient(), null);
    }

    /**
     * Gets a request builder for the ResourceSpecificPermissionGrant item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ResourceSpecificPermissionGrantRequestBuilder permissionGrants(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ResourceSpecificPermissionGrantRequestBuilder(getRequestUrlWithAdditionalSegment("permissionGrants") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the PinnedChatMessageInfo collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.PinnedChatMessageInfoCollectionRequestBuilder pinnedMessages() {
        return new com.microsoft.graph.requests.PinnedChatMessageInfoCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("pinnedMessages"), getClient(), null);
    }

    /**
     * Gets a request builder for the PinnedChatMessageInfo item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.PinnedChatMessageInfoRequestBuilder pinnedMessages(@Nonnull final String id) {
        return new com.microsoft.graph.requests.PinnedChatMessageInfoRequestBuilder(getRequestUrlWithAdditionalSegment("pinnedMessages") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the TeamsTab collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.TeamsTabCollectionRequestBuilder tabs() {
        return new com.microsoft.graph.requests.TeamsTabCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("tabs"), getClient(), null);
    }

    /**
     * Gets a request builder for the TeamsTab item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.TeamsTabRequestBuilder tabs(@Nonnull final String id) {
        return new com.microsoft.graph.requests.TeamsTabRequestBuilder(getRequestUrlWithAdditionalSegment("tabs") + "/" + id, getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public ChatSendActivityNotificationRequestBuilder sendActivityNotification(@Nonnull final ChatSendActivityNotificationParameterSet parameters) {
        return new ChatSendActivityNotificationRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.sendActivityNotification"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public ChatHideForUserRequestBuilder hideForUser(@Nonnull final ChatHideForUserParameterSet parameters) {
        return new ChatHideForUserRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.hideForUser"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public ChatMarkChatReadForUserRequestBuilder markChatReadForUser(@Nonnull final ChatMarkChatReadForUserParameterSet parameters) {
        return new ChatMarkChatReadForUserRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.markChatReadForUser"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public ChatMarkChatUnreadForUserRequestBuilder markChatUnreadForUser(@Nonnull final ChatMarkChatUnreadForUserParameterSet parameters) {
        return new ChatMarkChatUnreadForUserRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.markChatUnreadForUser"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public ChatUnhideForUserRequestBuilder unhideForUser(@Nonnull final ChatUnhideForUserParameterSet parameters) {
        return new ChatUnhideForUserRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.unhideForUser"), getClient(), null, parameters);
    }
}
