// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EducationPointsOutcome;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education Points Outcome Request.
 */
public class EducationPointsOutcomeRequest extends BaseRequest<EducationPointsOutcome> {
	
    /**
     * The request for the EducationPointsOutcome
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EducationPointsOutcomeRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationPointsOutcome.class);
    }

    /**
     * Gets the EducationPointsOutcome from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationPointsOutcome> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EducationPointsOutcome from the service
     *
     * @return the EducationPointsOutcome from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationPointsOutcome get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationPointsOutcome> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EducationPointsOutcome delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EducationPointsOutcome with a source
     *
     * @param sourceEducationPointsOutcome the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationPointsOutcome> patchAsync(@Nonnull final EducationPointsOutcome sourceEducationPointsOutcome) {
        return sendAsync(HttpMethod.PATCH, sourceEducationPointsOutcome);
    }

    /**
     * Patches this EducationPointsOutcome with a source
     *
     * @param sourceEducationPointsOutcome the source object with updates
     * @return the updated EducationPointsOutcome
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationPointsOutcome patch(@Nonnull final EducationPointsOutcome sourceEducationPointsOutcome) throws ClientException {
        return send(HttpMethod.PATCH, sourceEducationPointsOutcome);
    }

    /**
     * Creates a EducationPointsOutcome with a new object
     *
     * @param newEducationPointsOutcome the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationPointsOutcome> postAsync(@Nonnull final EducationPointsOutcome newEducationPointsOutcome) {
        return sendAsync(HttpMethod.POST, newEducationPointsOutcome);
    }

    /**
     * Creates a EducationPointsOutcome with a new object
     *
     * @param newEducationPointsOutcome the new object to create
     * @return the created EducationPointsOutcome
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationPointsOutcome post(@Nonnull final EducationPointsOutcome newEducationPointsOutcome) throws ClientException {
        return send(HttpMethod.POST, newEducationPointsOutcome);
    }

    /**
     * Creates a EducationPointsOutcome with a new object
     *
     * @param newEducationPointsOutcome the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationPointsOutcome> putAsync(@Nonnull final EducationPointsOutcome newEducationPointsOutcome) {
        return sendAsync(HttpMethod.PUT, newEducationPointsOutcome);
    }

    /**
     * Creates a EducationPointsOutcome with a new object
     *
     * @param newEducationPointsOutcome the object to create/update
     * @return the created EducationPointsOutcome
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationPointsOutcome put(@Nonnull final EducationPointsOutcome newEducationPointsOutcome) throws ClientException {
        return send(HttpMethod.PUT, newEducationPointsOutcome);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EducationPointsOutcomeRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EducationPointsOutcomeRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

