// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EducationRubric;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education Rubric Request.
 */
public class EducationRubricRequest extends BaseRequest<EducationRubric> {
	
    /**
     * The request for the EducationRubric
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EducationRubricRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationRubric.class);
    }

    /**
     * Gets the EducationRubric from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationRubric> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EducationRubric from the service
     *
     * @return the EducationRubric from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationRubric get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationRubric> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EducationRubric delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EducationRubric with a source
     *
     * @param sourceEducationRubric the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationRubric> patchAsync(@Nonnull final EducationRubric sourceEducationRubric) {
        return sendAsync(HttpMethod.PATCH, sourceEducationRubric);
    }

    /**
     * Patches this EducationRubric with a source
     *
     * @param sourceEducationRubric the source object with updates
     * @return the updated EducationRubric
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationRubric patch(@Nonnull final EducationRubric sourceEducationRubric) throws ClientException {
        return send(HttpMethod.PATCH, sourceEducationRubric);
    }

    /**
     * Creates a EducationRubric with a new object
     *
     * @param newEducationRubric the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationRubric> postAsync(@Nonnull final EducationRubric newEducationRubric) {
        return sendAsync(HttpMethod.POST, newEducationRubric);
    }

    /**
     * Creates a EducationRubric with a new object
     *
     * @param newEducationRubric the new object to create
     * @return the created EducationRubric
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationRubric post(@Nonnull final EducationRubric newEducationRubric) throws ClientException {
        return send(HttpMethod.POST, newEducationRubric);
    }

    /**
     * Creates a EducationRubric with a new object
     *
     * @param newEducationRubric the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationRubric> putAsync(@Nonnull final EducationRubric newEducationRubric) {
        return sendAsync(HttpMethod.PUT, newEducationRubric);
    }

    /**
     * Creates a EducationRubric with a new object
     *
     * @param newEducationRubric the object to create/update
     * @return the created EducationRubric
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationRubric put(@Nonnull final EducationRubric newEducationRubric) throws ClientException {
        return send(HttpMethod.PUT, newEducationRubric);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EducationRubricRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EducationRubricRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

