// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EducationSubmission;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education Submission Request.
 */
public class EducationSubmissionRequest extends BaseRequest<EducationSubmission> {
	
    /**
     * The request for the EducationSubmission
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EducationSubmissionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationSubmission.class);
    }

    /**
     * Gets the EducationSubmission from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationSubmission> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EducationSubmission from the service
     *
     * @return the EducationSubmission from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationSubmission get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationSubmission> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EducationSubmission delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EducationSubmission with a source
     *
     * @param sourceEducationSubmission the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationSubmission> patchAsync(@Nonnull final EducationSubmission sourceEducationSubmission) {
        return sendAsync(HttpMethod.PATCH, sourceEducationSubmission);
    }

    /**
     * Patches this EducationSubmission with a source
     *
     * @param sourceEducationSubmission the source object with updates
     * @return the updated EducationSubmission
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationSubmission patch(@Nonnull final EducationSubmission sourceEducationSubmission) throws ClientException {
        return send(HttpMethod.PATCH, sourceEducationSubmission);
    }

    /**
     * Creates a EducationSubmission with a new object
     *
     * @param newEducationSubmission the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationSubmission> postAsync(@Nonnull final EducationSubmission newEducationSubmission) {
        return sendAsync(HttpMethod.POST, newEducationSubmission);
    }

    /**
     * Creates a EducationSubmission with a new object
     *
     * @param newEducationSubmission the new object to create
     * @return the created EducationSubmission
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationSubmission post(@Nonnull final EducationSubmission newEducationSubmission) throws ClientException {
        return send(HttpMethod.POST, newEducationSubmission);
    }

    /**
     * Creates a EducationSubmission with a new object
     *
     * @param newEducationSubmission the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationSubmission> putAsync(@Nonnull final EducationSubmission newEducationSubmission) {
        return sendAsync(HttpMethod.PUT, newEducationSubmission);
    }

    /**
     * Creates a EducationSubmission with a new object
     *
     * @param newEducationSubmission the object to create/update
     * @return the created EducationSubmission
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationSubmission put(@Nonnull final EducationSubmission newEducationSubmission) throws ClientException {
        return send(HttpMethod.PUT, newEducationSubmission);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EducationSubmissionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EducationSubmissionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

