// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EntitlementManagement;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Entitlement Management Request Builder.
 */
public class EntitlementManagementRequestBuilder extends BaseRequestBuilder<EntitlementManagement> {

    /**
     * The request builder for the EntitlementManagement
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EntitlementManagementRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the EntitlementManagementRequest instance
     */
    @Nonnull
    public EntitlementManagementRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the EntitlementManagementRequest instance
     */
    @Nonnull
    public EntitlementManagementRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.EntitlementManagementRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the Approval collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ApprovalCollectionRequestBuilder accessPackageAssignmentApprovals() {
        return new com.microsoft.graph.requests.ApprovalCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("accessPackageAssignmentApprovals"), getClient(), null);
    }

    /**
     * Gets a request builder for the Approval item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ApprovalRequestBuilder accessPackageAssignmentApprovals(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ApprovalRequestBuilder(getRequestUrlWithAdditionalSegment("accessPackageAssignmentApprovals") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the AccessPackage collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.AccessPackageCollectionRequestBuilder accessPackages() {
        return new com.microsoft.graph.requests.AccessPackageCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("accessPackages"), getClient(), null);
    }

    /**
     * Gets a request builder for the AccessPackage item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.AccessPackageRequestBuilder accessPackages(@Nonnull final String id) {
        return new com.microsoft.graph.requests.AccessPackageRequestBuilder(getRequestUrlWithAdditionalSegment("accessPackages") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the AccessPackageAssignmentPolicy collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.AccessPackageAssignmentPolicyCollectionRequestBuilder assignmentPolicies() {
        return new com.microsoft.graph.requests.AccessPackageAssignmentPolicyCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("assignmentPolicies"), getClient(), null);
    }

    /**
     * Gets a request builder for the AccessPackageAssignmentPolicy item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.AccessPackageAssignmentPolicyRequestBuilder assignmentPolicies(@Nonnull final String id) {
        return new com.microsoft.graph.requests.AccessPackageAssignmentPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("assignmentPolicies") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the AccessPackageAssignmentRequest collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.AccessPackageAssignmentRequestCollectionRequestBuilder assignmentRequests() {
        return new com.microsoft.graph.requests.AccessPackageAssignmentRequestCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("assignmentRequests"), getClient(), null);
    }

    /**
     * Gets a request builder for the AccessPackageAssignmentRequest item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.AccessPackageAssignmentRequestRequestBuilder assignmentRequests(@Nonnull final String id) {
        return new com.microsoft.graph.requests.AccessPackageAssignmentRequestRequestBuilder(getRequestUrlWithAdditionalSegment("assignmentRequests") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the AccessPackageAssignment collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.AccessPackageAssignmentCollectionRequestBuilder assignments() {
        return new com.microsoft.graph.requests.AccessPackageAssignmentCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("assignments"), getClient(), null);
    }

    /**
     * Gets a request builder for the AccessPackageAssignment item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.AccessPackageAssignmentRequestBuilder assignments(@Nonnull final String id) {
        return new com.microsoft.graph.requests.AccessPackageAssignmentRequestBuilder(getRequestUrlWithAdditionalSegment("assignments") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the AccessPackageCatalog collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.AccessPackageCatalogCollectionRequestBuilder catalogs() {
        return new com.microsoft.graph.requests.AccessPackageCatalogCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("catalogs"), getClient(), null);
    }

    /**
     * Gets a request builder for the AccessPackageCatalog item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.AccessPackageCatalogRequestBuilder catalogs(@Nonnull final String id) {
        return new com.microsoft.graph.requests.AccessPackageCatalogRequestBuilder(getRequestUrlWithAdditionalSegment("catalogs") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the ConnectedOrganization collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ConnectedOrganizationCollectionRequestBuilder connectedOrganizations() {
        return new com.microsoft.graph.requests.ConnectedOrganizationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("connectedOrganizations"), getClient(), null);
    }

    /**
     * Gets a request builder for the ConnectedOrganization item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ConnectedOrganizationRequestBuilder connectedOrganizations(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ConnectedOrganizationRequestBuilder(getRequestUrlWithAdditionalSegment("connectedOrganizations") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the AccessPackageResourceEnvironment collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.AccessPackageResourceEnvironmentCollectionRequestBuilder resourceEnvironments() {
        return new com.microsoft.graph.requests.AccessPackageResourceEnvironmentCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("resourceEnvironments"), getClient(), null);
    }

    /**
     * Gets a request builder for the AccessPackageResourceEnvironment item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.AccessPackageResourceEnvironmentRequestBuilder resourceEnvironments(@Nonnull final String id) {
        return new com.microsoft.graph.requests.AccessPackageResourceEnvironmentRequestBuilder(getRequestUrlWithAdditionalSegment("resourceEnvironments") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the AccessPackageResourceRequest collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.AccessPackageResourceRequestCollectionRequestBuilder resourceRequests() {
        return new com.microsoft.graph.requests.AccessPackageResourceRequestCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("resourceRequests"), getClient(), null);
    }

    /**
     * Gets a request builder for the AccessPackageResourceRequest item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.AccessPackageResourceRequestRequestBuilder resourceRequests(@Nonnull final String id) {
        return new com.microsoft.graph.requests.AccessPackageResourceRequestRequestBuilder(getRequestUrlWithAdditionalSegment("resourceRequests") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the AccessPackageResourceRoleScope collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.AccessPackageResourceRoleScopeCollectionRequestBuilder resourceRoleScopes() {
        return new com.microsoft.graph.requests.AccessPackageResourceRoleScopeCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("resourceRoleScopes"), getClient(), null);
    }

    /**
     * Gets a request builder for the AccessPackageResourceRoleScope item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.AccessPackageResourceRoleScopeRequestBuilder resourceRoleScopes(@Nonnull final String id) {
        return new com.microsoft.graph.requests.AccessPackageResourceRoleScopeRequestBuilder(getRequestUrlWithAdditionalSegment("resourceRoleScopes") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the AccessPackageResource collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.AccessPackageResourceCollectionRequestBuilder resources() {
        return new com.microsoft.graph.requests.AccessPackageResourceCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("resources"), getClient(), null);
    }

    /**
     * Gets a request builder for the AccessPackageResource item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.AccessPackageResourceRequestBuilder resources(@Nonnull final String id) {
        return new com.microsoft.graph.requests.AccessPackageResourceRequestBuilder(getRequestUrlWithAdditionalSegment("resources") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for EntitlementManagementSettings
     *
     * @return the EntitlementManagementSettingsRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.EntitlementManagementSettingsRequestBuilder settings() {
        return new com.microsoft.graph.requests.EntitlementManagementSettingsRequestBuilder(getRequestUrlWithAdditionalSegment("settings"), getClient(), null);
    }
}
