// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ExtensionProperty;
import com.microsoft.graph.models.DirectoryObject;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Extension Property Request.
 */
public class ExtensionPropertyRequest extends BaseRequest<ExtensionProperty> {
	
    /**
     * The request for the ExtensionProperty
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ExtensionPropertyRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ExtensionProperty.class);
    }

    /**
     * Gets the ExtensionProperty from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ExtensionProperty> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ExtensionProperty from the service
     *
     * @return the ExtensionProperty from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ExtensionProperty get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ExtensionProperty> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ExtensionProperty delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ExtensionProperty with a source
     *
     * @param sourceExtensionProperty the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ExtensionProperty> patchAsync(@Nonnull final ExtensionProperty sourceExtensionProperty) {
        return sendAsync(HttpMethod.PATCH, sourceExtensionProperty);
    }

    /**
     * Patches this ExtensionProperty with a source
     *
     * @param sourceExtensionProperty the source object with updates
     * @return the updated ExtensionProperty
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ExtensionProperty patch(@Nonnull final ExtensionProperty sourceExtensionProperty) throws ClientException {
        return send(HttpMethod.PATCH, sourceExtensionProperty);
    }

    /**
     * Creates a ExtensionProperty with a new object
     *
     * @param newExtensionProperty the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ExtensionProperty> postAsync(@Nonnull final ExtensionProperty newExtensionProperty) {
        return sendAsync(HttpMethod.POST, newExtensionProperty);
    }

    /**
     * Creates a ExtensionProperty with a new object
     *
     * @param newExtensionProperty the new object to create
     * @return the created ExtensionProperty
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ExtensionProperty post(@Nonnull final ExtensionProperty newExtensionProperty) throws ClientException {
        return send(HttpMethod.POST, newExtensionProperty);
    }

    /**
     * Creates a ExtensionProperty with a new object
     *
     * @param newExtensionProperty the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ExtensionProperty> putAsync(@Nonnull final ExtensionProperty newExtensionProperty) {
        return sendAsync(HttpMethod.PUT, newExtensionProperty);
    }

    /**
     * Creates a ExtensionProperty with a new object
     *
     * @param newExtensionProperty the object to create/update
     * @return the created ExtensionProperty
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ExtensionProperty put(@Nonnull final ExtensionProperty newExtensionProperty) throws ClientException {
        return send(HttpMethod.PUT, newExtensionProperty);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ExtensionPropertyRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ExtensionPropertyRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

