// Template Source: BaseEntityCollectionRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Authentication;
import com.microsoft.graph.models.Fido2AuthenticationMethod;
import com.microsoft.graph.models.PasswordResetResponse;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.requests.Fido2AuthenticationMethodCollectionResponse;
import com.microsoft.graph.requests.Fido2AuthenticationMethodCollectionRequestBuilder;
import com.microsoft.graph.requests.Fido2AuthenticationMethodCollectionRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Fido2Authentication Method Collection Request.
 */
public class Fido2AuthenticationMethodCollectionRequest extends BaseEntityCollectionRequest<Fido2AuthenticationMethod, Fido2AuthenticationMethodCollectionResponse, Fido2AuthenticationMethodCollectionPage> {

    /**
     * The request builder for this collection of Fido2AuthenticationMethod
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public Fido2AuthenticationMethodCollectionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Fido2AuthenticationMethodCollectionResponse.class, Fido2AuthenticationMethodCollectionPage.class, Fido2AuthenticationMethodCollectionRequestBuilder.class);
    }

    /**
     * Creates a new Fido2AuthenticationMethod
     * @param newFido2AuthenticationMethod the Fido2AuthenticationMethod to create
     * @return a future with the created object
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Fido2AuthenticationMethod> postAsync(@Nonnull final Fido2AuthenticationMethod newFido2AuthenticationMethod) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new Fido2AuthenticationMethodRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .postAsync(newFido2AuthenticationMethod);
    }

    /**
     * Creates a new Fido2AuthenticationMethod
     * @param newFido2AuthenticationMethod the Fido2AuthenticationMethod to create
     * @return the newly created object
     */
    @Nonnull
    public Fido2AuthenticationMethod post(@Nonnull final Fido2AuthenticationMethod newFido2AuthenticationMethod) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new Fido2AuthenticationMethodRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .post(newFido2AuthenticationMethod);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    @Nonnull
    public Fido2AuthenticationMethodCollectionRequest expand(@Nonnull final String value) {
        addExpandOption(value);
        return this;
    }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
    @Nonnull
    public Fido2AuthenticationMethodCollectionRequest filter(@Nonnull final String value) {
        addFilterOption(value);
        return this;
    }

    /**
     * Sets the order by clause for the request
     *
     * @param value the order by clause
     * @return the updated request
     */
    @Nonnull
    public Fido2AuthenticationMethodCollectionRequest orderBy(@Nonnull final String value) {
        addOrderByOption(value);
        return this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    @Nonnull
    public Fido2AuthenticationMethodCollectionRequest select(@Nonnull final String value) {
        addSelectOption(value);
        return this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    @Nonnull
    public Fido2AuthenticationMethodCollectionRequest top(final int value) {
        addTopOption(value);
        return this;
    }

    /**
     * Sets the count value for the request
     *
     * @param value whether or not to return the count of objects with the request
     * @return the updated request
     */
    @Nonnull
    public Fido2AuthenticationMethodCollectionRequest count(final boolean value) {
        addCountOption(value);
        return this;
    }
    /**
     * Sets the count value to true for the request
     *
     * @return the updated request
     */
    @Nonnull
    public Fido2AuthenticationMethodCollectionRequest count() {
        addCountOption(true);
        return this;
    }
    /**
     * Sets the skip value for the request
     *
     * @param value of the number of items to skip
     * @return the updated request
     */
    @Nonnull
    public Fido2AuthenticationMethodCollectionRequest skip(final int value) {
        addSkipOption(value);
        return this;
    }


    /**
     * Add Skip token for pagination
     * @param skipToken - Token for pagination
     * @return the updated request
     */
    @Nonnull
    public Fido2AuthenticationMethodCollectionRequest skipToken(@Nonnull final String skipToken) {
    	addSkipTokenOption(skipToken);
        return this;
    }
}

