// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Fido2CombinationConfiguration;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Fido2Combination Configuration Request.
 */
public class Fido2CombinationConfigurationRequest extends BaseRequest<Fido2CombinationConfiguration> {
	
    /**
     * The request for the Fido2CombinationConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public Fido2CombinationConfigurationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Fido2CombinationConfiguration.class);
    }

    /**
     * Gets the Fido2CombinationConfiguration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Fido2CombinationConfiguration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Fido2CombinationConfiguration from the service
     *
     * @return the Fido2CombinationConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Fido2CombinationConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Fido2CombinationConfiguration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Fido2CombinationConfiguration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Fido2CombinationConfiguration with a source
     *
     * @param sourceFido2CombinationConfiguration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Fido2CombinationConfiguration> patchAsync(@Nonnull final Fido2CombinationConfiguration sourceFido2CombinationConfiguration) {
        return sendAsync(HttpMethod.PATCH, sourceFido2CombinationConfiguration);
    }

    /**
     * Patches this Fido2CombinationConfiguration with a source
     *
     * @param sourceFido2CombinationConfiguration the source object with updates
     * @return the updated Fido2CombinationConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Fido2CombinationConfiguration patch(@Nonnull final Fido2CombinationConfiguration sourceFido2CombinationConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceFido2CombinationConfiguration);
    }

    /**
     * Creates a Fido2CombinationConfiguration with a new object
     *
     * @param newFido2CombinationConfiguration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Fido2CombinationConfiguration> postAsync(@Nonnull final Fido2CombinationConfiguration newFido2CombinationConfiguration) {
        return sendAsync(HttpMethod.POST, newFido2CombinationConfiguration);
    }

    /**
     * Creates a Fido2CombinationConfiguration with a new object
     *
     * @param newFido2CombinationConfiguration the new object to create
     * @return the created Fido2CombinationConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Fido2CombinationConfiguration post(@Nonnull final Fido2CombinationConfiguration newFido2CombinationConfiguration) throws ClientException {
        return send(HttpMethod.POST, newFido2CombinationConfiguration);
    }

    /**
     * Creates a Fido2CombinationConfiguration with a new object
     *
     * @param newFido2CombinationConfiguration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Fido2CombinationConfiguration> putAsync(@Nonnull final Fido2CombinationConfiguration newFido2CombinationConfiguration) {
        return sendAsync(HttpMethod.PUT, newFido2CombinationConfiguration);
    }

    /**
     * Creates a Fido2CombinationConfiguration with a new object
     *
     * @param newFido2CombinationConfiguration the object to create/update
     * @return the created Fido2CombinationConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Fido2CombinationConfiguration put(@Nonnull final Fido2CombinationConfiguration newFido2CombinationConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newFido2CombinationConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public Fido2CombinationConfigurationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public Fido2CombinationConfigurationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

