// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ImportedWindowsAutopilotDeviceIdentity;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.ImportedWindowsAutopilotDeviceIdentityImportCollectionRequestBuilder;
import com.microsoft.graph.requests.ImportedWindowsAutopilotDeviceIdentityImportCollectionRequest;
import com.microsoft.graph.requests.ImportedWindowsAutopilotDeviceIdentityImportCollectionResponse;
import com.microsoft.graph.models.ImportedWindowsAutopilotDeviceIdentityImportParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseActionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Imported Windows Autopilot Device Identity Import Collection Request Builder.
 */
public class ImportedWindowsAutopilotDeviceIdentityImportCollectionRequestBuilder extends BaseActionCollectionRequestBuilder<ImportedWindowsAutopilotDeviceIdentity, ImportedWindowsAutopilotDeviceIdentityImportCollectionRequestBuilder, ImportedWindowsAutopilotDeviceIdentityImportCollectionResponse, ImportedWindowsAutopilotDeviceIdentityImportCollectionPage, ImportedWindowsAutopilotDeviceIdentityImportCollectionRequest> {

    /**
     * The request builder for this collection of ImportedWindowsAutopilotDeviceIdentity
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ImportedWindowsAutopilotDeviceIdentityImportCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ImportedWindowsAutopilotDeviceIdentityImportCollectionRequestBuilder.class, ImportedWindowsAutopilotDeviceIdentityImportCollectionRequest.class);
    }
    private ImportedWindowsAutopilotDeviceIdentityImportParameterSet body;
    /**
     * The request builder for this collection of ImportedWindowsAutopilotDeviceIdentity
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public ImportedWindowsAutopilotDeviceIdentityImportCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final ImportedWindowsAutopilotDeviceIdentityImportParameterSet parameters) {
        super(requestUrl, client, requestOptions, ImportedWindowsAutopilotDeviceIdentityImportCollectionRequestBuilder.class, ImportedWindowsAutopilotDeviceIdentityImportCollectionRequest.class);
        this.body = parameters;
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the ImportedWindowsAutopilotDeviceIdentityImportCollectionRequest instance
     */
    @Override
    @Nonnull
    public ImportedWindowsAutopilotDeviceIdentityImportCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final ImportedWindowsAutopilotDeviceIdentityImportCollectionRequest request = super.buildRequest(requestOptions);
            request.body = this.body;
            return request;
    }
}
