// Template Source: BaseEntityCollectionReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EmployeeExperienceUser;
import com.microsoft.graph.models.LearningCourseActivity;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.LearningCourseActivityWithReferenceRequest;
import com.microsoft.graph.requests.LearningCourseActivityReferenceRequestBuilder;
import com.microsoft.graph.requests.LearningCourseActivityWithReferenceRequestBuilder;
import com.microsoft.graph.requests.LearningCourseActivityCollectionWithReferencesRequest;
import com.microsoft.graph.requests.LearningCourseActivityCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.models.LearningCourseActivity;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionWithReferencesRequest;
import com.microsoft.graph.http.BaseCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.http.ReferenceRequestBody;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Learning Course Activity Collection Reference Request.
 */
public class LearningCourseActivityCollectionReferenceRequest extends BaseCollectionWithReferencesRequest<LearningCourseActivity, LearningCourseActivityWithReferenceRequest, LearningCourseActivityReferenceRequestBuilder, LearningCourseActivityWithReferenceRequestBuilder, LearningCourseActivityCollectionResponse, LearningCourseActivityCollectionWithReferencesPage, LearningCourseActivityCollectionWithReferencesRequest> {

    /**
     * The request builder for this collection of LearningCourseActivity
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public LearningCourseActivityCollectionReferenceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, LearningCourseActivityCollectionResponse.class, LearningCourseActivityCollectionWithReferencesPage.class, LearningCourseActivityCollectionWithReferencesRequestBuilder.class);
    }

    /**
     * Creates a new LearningCourseActivity
     * @param newLearningCourseActivity the LearningCourseActivity to create
     * @return a future with the created object
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningCourseActivity> postAsync(@Nonnull final LearningCourseActivity newLearningCourseActivity) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        final ReferenceRequestBody body = new ReferenceRequestBody(getBaseRequest().getClient().getServiceRoot() + "/employeeExperience/learningCourseActivities/" + newLearningCourseActivity.id);
        return new LearningCourseActivityWithReferenceRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .postAsync(newLearningCourseActivity, body);
    }

    /**
     * Creates a new LearningCourseActivity
     * @param newLearningCourseActivity the LearningCourseActivity to create
     * @return the newly created object
     */
    @Nonnull
    public LearningCourseActivity post(@Nonnull final LearningCourseActivity newLearningCourseActivity) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        final ReferenceRequestBody body = new ReferenceRequestBody(getBaseRequest().getClient().getServiceRoot() + "/employeeExperience/learningCourseActivities/" + newLearningCourseActivity.id);
        return new LearningCourseActivityWithReferenceRequestBuilder(requestUrl,getBaseRequest().getClient(), /* Options */ null)
                .buildRequest(getBaseRequest().getHeaders())
                .post(newLearningCourseActivity, body);
    }
    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    @Nonnull
    public LearningCourseActivityCollectionReferenceRequest expand(@Nonnull final String value) {
        addExpandOption(value);
        return this;
    }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
    @Nonnull
    public LearningCourseActivityCollectionReferenceRequest filter(@Nonnull final String value) {
        addFilterOption(value);
        return this;
    }

    /**
     * Sets the order by clause for the request
     *
     * @param value the sort clause
     * @return the updated request
     */
    @Nonnull
    public LearningCourseActivityCollectionReferenceRequest orderBy(@Nonnull final String value) {
        addOrderByOption(value);
        return this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    @Nonnull
    public LearningCourseActivityCollectionReferenceRequest select(@Nonnull final String value) {
        addSelectOption(value);
        return this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    @Nonnull
    public LearningCourseActivityCollectionReferenceRequest top(final int value) {
        addTopOption(value);
        return this;
    }
    /**
     * Sets the count value for the request
     *
     * @param value whether or not to return the count of objects with the request
     * @return the updated request
     */
    @Nonnull
    public LearningCourseActivityCollectionReferenceRequest count(final boolean value) {
        addCountOption(value);
        return this;
    }
    /**
     * Sets the count value to true for the request
     *
     * @return the updated request
     */
    @Nonnull
    public LearningCourseActivityCollectionReferenceRequest count() {
        addCountOption(true);
        return this;
    }
}
