// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.MacOSCustomConfiguration;
import com.microsoft.graph.models.DeviceConfigurationAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mac OSCustom Configuration Request.
 */
public class MacOSCustomConfigurationRequest extends BaseRequest<MacOSCustomConfiguration> {
	
    /**
     * The request for the MacOSCustomConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MacOSCustomConfigurationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MacOSCustomConfiguration.class);
    }

    /**
     * Gets the MacOSCustomConfiguration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSCustomConfiguration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the MacOSCustomConfiguration from the service
     *
     * @return the MacOSCustomConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MacOSCustomConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSCustomConfiguration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public MacOSCustomConfiguration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MacOSCustomConfiguration with a source
     *
     * @param sourceMacOSCustomConfiguration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSCustomConfiguration> patchAsync(@Nonnull final MacOSCustomConfiguration sourceMacOSCustomConfiguration) {
        return sendAsync(HttpMethod.PATCH, sourceMacOSCustomConfiguration);
    }

    /**
     * Patches this MacOSCustomConfiguration with a source
     *
     * @param sourceMacOSCustomConfiguration the source object with updates
     * @return the updated MacOSCustomConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MacOSCustomConfiguration patch(@Nonnull final MacOSCustomConfiguration sourceMacOSCustomConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceMacOSCustomConfiguration);
    }

    /**
     * Creates a MacOSCustomConfiguration with a new object
     *
     * @param newMacOSCustomConfiguration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSCustomConfiguration> postAsync(@Nonnull final MacOSCustomConfiguration newMacOSCustomConfiguration) {
        return sendAsync(HttpMethod.POST, newMacOSCustomConfiguration);
    }

    /**
     * Creates a MacOSCustomConfiguration with a new object
     *
     * @param newMacOSCustomConfiguration the new object to create
     * @return the created MacOSCustomConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MacOSCustomConfiguration post(@Nonnull final MacOSCustomConfiguration newMacOSCustomConfiguration) throws ClientException {
        return send(HttpMethod.POST, newMacOSCustomConfiguration);
    }

    /**
     * Creates a MacOSCustomConfiguration with a new object
     *
     * @param newMacOSCustomConfiguration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSCustomConfiguration> putAsync(@Nonnull final MacOSCustomConfiguration newMacOSCustomConfiguration) {
        return sendAsync(HttpMethod.PUT, newMacOSCustomConfiguration);
    }

    /**
     * Creates a MacOSCustomConfiguration with a new object
     *
     * @param newMacOSCustomConfiguration the object to create/update
     * @return the created MacOSCustomConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MacOSCustomConfiguration put(@Nonnull final MacOSCustomConfiguration newMacOSCustomConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newMacOSCustomConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public MacOSCustomConfigurationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public MacOSCustomConfigurationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

