// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.MacOSDeviceFeaturesConfiguration;
import com.microsoft.graph.models.DeviceConfigurationAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mac OSDevice Features Configuration Request.
 */
public class MacOSDeviceFeaturesConfigurationRequest extends BaseRequest<MacOSDeviceFeaturesConfiguration> {
	
    /**
     * The request for the MacOSDeviceFeaturesConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MacOSDeviceFeaturesConfigurationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MacOSDeviceFeaturesConfiguration.class);
    }

    /**
     * Gets the MacOSDeviceFeaturesConfiguration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSDeviceFeaturesConfiguration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the MacOSDeviceFeaturesConfiguration from the service
     *
     * @return the MacOSDeviceFeaturesConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MacOSDeviceFeaturesConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSDeviceFeaturesConfiguration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public MacOSDeviceFeaturesConfiguration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MacOSDeviceFeaturesConfiguration with a source
     *
     * @param sourceMacOSDeviceFeaturesConfiguration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSDeviceFeaturesConfiguration> patchAsync(@Nonnull final MacOSDeviceFeaturesConfiguration sourceMacOSDeviceFeaturesConfiguration) {
        return sendAsync(HttpMethod.PATCH, sourceMacOSDeviceFeaturesConfiguration);
    }

    /**
     * Patches this MacOSDeviceFeaturesConfiguration with a source
     *
     * @param sourceMacOSDeviceFeaturesConfiguration the source object with updates
     * @return the updated MacOSDeviceFeaturesConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MacOSDeviceFeaturesConfiguration patch(@Nonnull final MacOSDeviceFeaturesConfiguration sourceMacOSDeviceFeaturesConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceMacOSDeviceFeaturesConfiguration);
    }

    /**
     * Creates a MacOSDeviceFeaturesConfiguration with a new object
     *
     * @param newMacOSDeviceFeaturesConfiguration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSDeviceFeaturesConfiguration> postAsync(@Nonnull final MacOSDeviceFeaturesConfiguration newMacOSDeviceFeaturesConfiguration) {
        return sendAsync(HttpMethod.POST, newMacOSDeviceFeaturesConfiguration);
    }

    /**
     * Creates a MacOSDeviceFeaturesConfiguration with a new object
     *
     * @param newMacOSDeviceFeaturesConfiguration the new object to create
     * @return the created MacOSDeviceFeaturesConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MacOSDeviceFeaturesConfiguration post(@Nonnull final MacOSDeviceFeaturesConfiguration newMacOSDeviceFeaturesConfiguration) throws ClientException {
        return send(HttpMethod.POST, newMacOSDeviceFeaturesConfiguration);
    }

    /**
     * Creates a MacOSDeviceFeaturesConfiguration with a new object
     *
     * @param newMacOSDeviceFeaturesConfiguration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSDeviceFeaturesConfiguration> putAsync(@Nonnull final MacOSDeviceFeaturesConfiguration newMacOSDeviceFeaturesConfiguration) {
        return sendAsync(HttpMethod.PUT, newMacOSDeviceFeaturesConfiguration);
    }

    /**
     * Creates a MacOSDeviceFeaturesConfiguration with a new object
     *
     * @param newMacOSDeviceFeaturesConfiguration the object to create/update
     * @return the created MacOSDeviceFeaturesConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MacOSDeviceFeaturesConfiguration put(@Nonnull final MacOSDeviceFeaturesConfiguration newMacOSDeviceFeaturesConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newMacOSDeviceFeaturesConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public MacOSDeviceFeaturesConfigurationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public MacOSDeviceFeaturesConfigurationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

