// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.MobileApp;
import com.microsoft.graph.models.MobileAppCategory;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.MobileAppCategoryCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.MobileAppCategoryCollectionWithReferencesPage;
import com.microsoft.graph.requests.MobileAppCategoryCollectionResponse;
import com.microsoft.graph.models.MobileAppCategory;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mobile App Category Collection With References Page.
 */
public class MobileAppCategoryCollectionWithReferencesPage extends BaseCollectionPage<MobileAppCategory, MobileAppCategoryCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for MobileAppCategory
     *
     * @param response the serialized MobileAppCategoryCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public MobileAppCategoryCollectionWithReferencesPage(@Nonnull final MobileAppCategoryCollectionResponse response, @Nullable final MobileAppCategoryCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for MobileAppCategory
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public MobileAppCategoryCollectionWithReferencesPage(@Nonnull final java.util.List<MobileAppCategory> pageContents, @Nullable final MobileAppCategoryCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
