// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.OnPremisesDirectorySynchronization;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the On Premises Directory Synchronization Request.
 */
public class OnPremisesDirectorySynchronizationRequest extends BaseRequest<OnPremisesDirectorySynchronization> {
	
    /**
     * The request for the OnPremisesDirectorySynchronization
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OnPremisesDirectorySynchronizationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, OnPremisesDirectorySynchronization.class);
    }

    /**
     * Gets the OnPremisesDirectorySynchronization from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OnPremisesDirectorySynchronization> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the OnPremisesDirectorySynchronization from the service
     *
     * @return the OnPremisesDirectorySynchronization from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OnPremisesDirectorySynchronization get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OnPremisesDirectorySynchronization> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public OnPremisesDirectorySynchronization delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this OnPremisesDirectorySynchronization with a source
     *
     * @param sourceOnPremisesDirectorySynchronization the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OnPremisesDirectorySynchronization> patchAsync(@Nonnull final OnPremisesDirectorySynchronization sourceOnPremisesDirectorySynchronization) {
        return sendAsync(HttpMethod.PATCH, sourceOnPremisesDirectorySynchronization);
    }

    /**
     * Patches this OnPremisesDirectorySynchronization with a source
     *
     * @param sourceOnPremisesDirectorySynchronization the source object with updates
     * @return the updated OnPremisesDirectorySynchronization
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OnPremisesDirectorySynchronization patch(@Nonnull final OnPremisesDirectorySynchronization sourceOnPremisesDirectorySynchronization) throws ClientException {
        return send(HttpMethod.PATCH, sourceOnPremisesDirectorySynchronization);
    }

    /**
     * Creates a OnPremisesDirectorySynchronization with a new object
     *
     * @param newOnPremisesDirectorySynchronization the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OnPremisesDirectorySynchronization> postAsync(@Nonnull final OnPremisesDirectorySynchronization newOnPremisesDirectorySynchronization) {
        return sendAsync(HttpMethod.POST, newOnPremisesDirectorySynchronization);
    }

    /**
     * Creates a OnPremisesDirectorySynchronization with a new object
     *
     * @param newOnPremisesDirectorySynchronization the new object to create
     * @return the created OnPremisesDirectorySynchronization
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OnPremisesDirectorySynchronization post(@Nonnull final OnPremisesDirectorySynchronization newOnPremisesDirectorySynchronization) throws ClientException {
        return send(HttpMethod.POST, newOnPremisesDirectorySynchronization);
    }

    /**
     * Creates a OnPremisesDirectorySynchronization with a new object
     *
     * @param newOnPremisesDirectorySynchronization the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OnPremisesDirectorySynchronization> putAsync(@Nonnull final OnPremisesDirectorySynchronization newOnPremisesDirectorySynchronization) {
        return sendAsync(HttpMethod.PUT, newOnPremisesDirectorySynchronization);
    }

    /**
     * Creates a OnPremisesDirectorySynchronization with a new object
     *
     * @param newOnPremisesDirectorySynchronization the object to create/update
     * @return the created OnPremisesDirectorySynchronization
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OnPremisesDirectorySynchronization put(@Nonnull final OnPremisesDirectorySynchronization newOnPremisesDirectorySynchronization) throws ClientException {
        return send(HttpMethod.PUT, newOnPremisesDirectorySynchronization);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public OnPremisesDirectorySynchronizationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public OnPremisesDirectorySynchronizationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

