// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Payload;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Payload Request.
 */
public class PayloadRequest extends BaseRequest<Payload> {
	
    /**
     * The request for the Payload
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PayloadRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Payload.class);
    }

    /**
     * Gets the Payload from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Payload> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Payload from the service
     *
     * @return the Payload from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Payload get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Payload> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Payload delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Payload with a source
     *
     * @param sourcePayload the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Payload> patchAsync(@Nonnull final Payload sourcePayload) {
        return sendAsync(HttpMethod.PATCH, sourcePayload);
    }

    /**
     * Patches this Payload with a source
     *
     * @param sourcePayload the source object with updates
     * @return the updated Payload
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Payload patch(@Nonnull final Payload sourcePayload) throws ClientException {
        return send(HttpMethod.PATCH, sourcePayload);
    }

    /**
     * Creates a Payload with a new object
     *
     * @param newPayload the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Payload> postAsync(@Nonnull final Payload newPayload) {
        return sendAsync(HttpMethod.POST, newPayload);
    }

    /**
     * Creates a Payload with a new object
     *
     * @param newPayload the new object to create
     * @return the created Payload
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Payload post(@Nonnull final Payload newPayload) throws ClientException {
        return send(HttpMethod.POST, newPayload);
    }

    /**
     * Creates a Payload with a new object
     *
     * @param newPayload the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Payload> putAsync(@Nonnull final Payload newPayload) {
        return sendAsync(HttpMethod.PUT, newPayload);
    }

    /**
     * Creates a Payload with a new object
     *
     * @param newPayload the object to create/update
     * @return the created Payload
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Payload put(@Nonnull final Payload newPayload) throws ClientException {
        return send(HttpMethod.PUT, newPayload);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PayloadRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PayloadRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

