// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EligibilityScheduleFilterByCurrentUserOptions;
import com.microsoft.graph.models.PrivilegedAccessGroupEligibilitySchedule;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserCollectionRequestBuilder;
import com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserCollectionRequest;
import com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserCollectionResponse;
import com.microsoft.graph.models.PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Privileged Access Group Eligibility Schedule Filter By Current User Collection Request Builder.
 */
public class PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<PrivilegedAccessGroupEligibilitySchedule, PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserCollectionRequestBuilder, PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserCollectionResponse, PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserCollectionPage, PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserCollectionRequest> {

    /**
     * The request builder for this collection of PrivilegedAccessGroupEligibilitySchedule
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserCollectionRequestBuilder.class, PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserCollectionRequest.class);
    }
    /**
     * The request builder for this collection of PrivilegedAccessGroupEligibilitySchedule
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserParameterSet parameters) {
        super(requestUrl, client, requestOptions, PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserCollectionRequestBuilder.class, PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserCollectionRequest.class);
        if(parameters != null) {
            functionOptions = parameters.getFunctionOptions();
        }
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserCollectionRequest instance
     */
    @Override
    @Nonnull
    public PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserCollectionRequest request = super.buildRequest(requestOptions);
        if(functionOptions != null) {    
            for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
                request.addFunctionOption(option);
            }
        }
        return request;
    }
}
